/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.utils;

public class HexUtils {
    private static final String HEXES = "0123456789ABCDEF";
    private static final String HEX_HEADER = "0x";

    public static String byteArrayToHexString(byte[] value) {
        if (value == null) {
            throw new NullPointerException("Value to convert cannot be null.");
        }
        StringBuilder hex = new StringBuilder(2 * value.length);
        for (byte b : value) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public static String byteToHexString(byte value) {
        StringBuilder hex = new StringBuilder(2);
        byte b = value;
        hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        return hex.toString();
    }

    public static byte[] hexStringToByteArray(String value) {
        int len;
        if (value == null) {
            throw new NullPointerException("Value to convert cannot be null.");
        }
        if ((value = value.trim()).startsWith(HEX_HEADER)) {
            value = value.substring(HEX_HEADER.length());
        }
        if ((len = value.length()) % 2 != 0) {
            value = "0" + value;
            len = value.length();
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(value.charAt(i), 16) << 4) + Character.digit(value.charAt(i + 1), 16));
        }
        return data;
    }

    public static boolean containsLetters(String parameter) {
        if (parameter == null) {
            throw new NullPointerException("Parameter cannot be null.");
        }
        byte[] byteArray = parameter.getBytes();
        for (int i = 0; i < byteArray.length; ++i) {
            if (byteArray[i] >= 48 && byteArray[i] <= 57) continue;
            return true;
        }
        return false;
    }

    public static String integerToHexString(int value, int minBytes) {
        if (minBytes <= 0) {
            throw new IllegalArgumentException("Minimum number of bytes must be greater than 0.");
        }
        String f = String.format("%%0%dX", minBytes * 2);
        return String.format(f, value);
    }

    public static String prettyHexString(String hexString) {
        if (hexString == null) {
            throw new NullPointerException("Hexadecimal string cannot be null.");
        }
        String copy = hexString.toUpperCase();
        for (char c : copy.toCharArray()) {
            if (HEXES.contains("" + c)) continue;
            throw new IllegalArgumentException("Given string cannot contain non-hexadecimal characters.");
        }
        String prettyHexString = "";
        if (copy.length() % 2 != 0) {
            copy = "0" + copy;
        }
        int iterations = copy.length() / 2;
        for (int i = 0; i < iterations; ++i) {
            prettyHexString = prettyHexString + copy.substring(2 * i, 2 * i + 2) + " ";
        }
        return prettyHexString.trim();
    }

    public static String prettyHexString(byte[] value) {
        return HexUtils.prettyHexString(HexUtils.byteArrayToHexString(value));
    }
}

