/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class ByteUtils {
    public static byte[] readBytes(int numBytes, ByteArrayInputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("Input stream cannot be null.");
        }
        if (numBytes < 0) {
            throw new IllegalArgumentException("Number of bytes to read must be equal or greater than 0.");
        }
        byte[] data = new byte[numBytes];
        int len = inputStream.read(data, 0, numBytes);
        if (len == -1) {
            return new byte[0];
        }
        if (len < numBytes) {
            byte[] d = new byte[len];
            System.arraycopy(data, 0, d, 0, len);
            return d;
        }
        return data;
    }

    public static String readString(ByteArrayInputStream inputStream) {
        byte readByte;
        if (inputStream == null) {
            throw new NullPointerException("Input stream cannot be null.");
        }
        StringBuilder sb = new StringBuilder();
        while ((readByte = (byte)inputStream.read()) != 0 && readByte != -1) {
            sb.append((char)readByte);
        }
        return sb.toString();
    }

    public static byte[] longToByteArray(long value) {
        return new byte[]{(byte)(value >>> 56 & 0xFFL), (byte)(value >>> 48 & 0xFFL), (byte)(value >>> 40 & 0xFFL), (byte)(value >>> 32 & 0xFFL), (byte)(value >>> 24 & 0xFFL), (byte)(value >>> 16 & 0xFFL), (byte)(value >>> 8 & 0xFFL), (byte)(value & 0xFFL)};
    }

    public static long byteArrayToLong(byte[] byteArray) {
        if (byteArray == null) {
            throw new NullPointerException("Byte array cannot be null.");
        }
        if (byteArray.length == 0) {
            return 0L;
        }
        byte[] values = byteArray;
        if (byteArray.length < 8) {
            int i;
            values = new byte[8];
            int diff = values.length - byteArray.length;
            for (i = 0; i < diff; ++i) {
                values[i] = 0;
            }
            for (i = diff; i < values.length; ++i) {
                values[i] = byteArray[i - diff];
            }
        }
        return ((long)values[0] << 56) + ((long)(values[1] & 0xFF) << 48) + ((long)(values[2] & 0xFF) << 40) + ((long)(values[3] & 0xFF) << 32) + ((long)(values[4] & 0xFF) << 24) + (long)((values[5] & 0xFF) << 16) + (long)((values[6] & 0xFF) << 8) + (long)(values[7] & 0xFF);
    }

    public static byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    public static int byteArrayToInt(byte[] byteArray) {
        if (byteArray == null) {
            throw new NullPointerException("Byte array cannot be null.");
        }
        if (byteArray.length == 0) {
            return 0;
        }
        byte[] values = byteArray;
        if (byteArray.length < 4) {
            int i;
            values = new byte[4];
            int diff = values.length - byteArray.length;
            for (i = 0; i < diff; ++i) {
                values[i] = 0;
            }
            for (i = diff; i < values.length; ++i) {
                values[i] = byteArray[i - diff];
            }
        }
        return (values[0] & 0xFF) << 24 | (values[1] & 0xFF) << 16 | (values[2] & 0xFF) << 8 | values[3] & 0xFF;
    }

    public static byte[] shortToByteArray(short value) {
        byte[] b = new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return b;
    }

    public static short byteArrayToShort(byte[] byteArray) {
        if (byteArray == null) {
            throw new NullPointerException("Byte array cannot be null.");
        }
        if (byteArray.length == 0) {
            return 0;
        }
        byte[] values = byteArray;
        if (byteArray.length < 2) {
            values = new byte[2];
            values[1] = byteArray[0];
            values[0] = 0;
        }
        return (short)(values[0] << 8 & 0xFF00 | values[1] & 0xFF);
    }

    public static byte[] stringToByteArray(String value) {
        if (value == null) {
            throw new NullPointerException("Value cannot be null.");
        }
        return value.getBytes();
    }

    public static String byteArrayToString(byte[] value) {
        if (value == null) {
            throw new NullPointerException("Byte array cannot be null.");
        }
        return new String(value);
    }

    public static int byteToInt(byte b) {
        return b & 0xFF;
    }

    public static boolean isBitEnabled(int containerInteger, int bitPosition) {
        if (bitPosition < 0 || bitPosition > 31) {
            throw new IllegalArgumentException("Bit position must be between 0 and 31.");
        }
        return ((containerInteger & 0xFFFFFFFF) >> bitPosition & 1) == 1;
    }

    public static int readIntegerFromByte(byte containerByte, int bitOffset, int bitLength) {
        if (bitOffset < 0 || bitOffset > 7) {
            throw new IllegalArgumentException("Offset must be between 0 and 7.");
        }
        if (bitLength < 0 || bitLength > 7) {
            throw new IllegalArgumentException("Length must be between 0 and 8.");
        }
        int readInteger = 0;
        for (int i = 0; i < bitLength && bitOffset + i <= 7; ++i) {
            if (!ByteUtils.isBitEnabled(containerByte, bitOffset + i)) continue;
            readInteger |= (int)Math.pow(2.0, i);
        }
        return readInteger;
    }

    public static boolean readBooleanFromByte(byte containerByte, int bitOffset) {
        if (bitOffset < 0 || bitOffset > 31) {
            throw new IllegalArgumentException("Bit offset must be between 0 and 7.");
        }
        return ByteUtils.isBitEnabled(containerByte, bitOffset);
    }

    public static byte[] readUntilCR(ByteArrayInputStream inputStream) {
        byte readByte;
        if (inputStream == null) {
            throw new NullPointerException("Input stream cannot be null.");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while ((readByte = (byte)inputStream.read()) != 13 && readByte != -1) {
            outputStream.write(readByte);
        }
        return outputStream.toByteArray();
    }

    public static byte[] newByteArray(byte[] data, int finalSize) {
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        if (finalSize < 0) {
            throw new IllegalArgumentException("Final size must be equal or greater than 0.");
        }
        if (finalSize == 0) {
            return new byte[0];
        }
        byte[] filledArray = new byte[finalSize];
        int diff = finalSize - data.length;
        if (diff >= 0) {
            for (int i = 0; i < diff; ++i) {
                filledArray[i] = 48;
            }
            System.arraycopy(data, 0, filledArray, diff, data.length);
        } else {
            System.arraycopy(data, 0, filledArray, 0, finalSize);
        }
        return filledArray;
    }

    public static byte[] swapByteArray(byte[] source) {
        if (source == null) {
            throw new NullPointerException("Source cannot be null.");
        }
        if (source.length == 0) {
            return new byte[0];
        }
        byte[] swapped = new byte[source.length];
        for (int i = 0; i < source.length; ++i) {
            swapped[source.length - i - 1] = source[i];
        }
        return swapped;
    }
}

