/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.wifi;

import com.digi.xbee.api.models.ATStringCommands;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteATCommandWifiPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 13;
    private static final String ERROR_PAYLOAD_NULL = "Remote AT Command Request (Wi-Fi) packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete Remote AT Command Request (Wi-Fi) packet.";
    private static final String ERROR_NOT_VALID_PACKET = "Payload is not a Remote AT Command Request (Wi-Fi) packet.";
    private static final String ERROR_FRAME_ID_ILLEGAL = "Frame ID must be between 0 and 255.";
    private static final String ERROR_DEST_ADDRESS_NULL = "Destination address cannot be null.";
    private static final String ERROR_OPTIONS_INVALID = "Receive options must be between 0 and 255.";
    private static final String ERROR_AT_COMMAND_NULL = "AT command cannot be null.";
    private final Inet4Address destAddress;
    private final int transmitOptions;
    private final String command;
    private byte[] parameter;
    private Logger logger;

    public static RemoteATCommandWifiPacket createPacket(byte[] payload) {
        Inet4Address destAddress;
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 13) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.REMOTE_AT_COMMAND_REQUEST_WIFI.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_VALID_PACKET);
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        ++index;
        try {
            destAddress = (Inet4Address)Inet4Address.getByAddress(Arrays.copyOfRange(payload, index + 4, index + 8));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        int transmitOptions = payload[index += 8] & 0xFF;
        String command = new String(new byte[]{payload[++index], payload[index + 1]});
        byte[] parameterData = null;
        if ((index += 2) < payload.length) {
            parameterData = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new RemoteATCommandWifiPacket(frameID, destAddress, transmitOptions, command, parameterData);
    }

    public RemoteATCommandWifiPacket(int frameID, Inet4Address destAddress, int transmitOptions, String command, byte[] parameter) {
        super(APIFrameType.REMOTE_AT_COMMAND_REQUEST_WIFI);
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException(ERROR_FRAME_ID_ILLEGAL);
        }
        if (destAddress == null) {
            throw new NullPointerException(ERROR_DEST_ADDRESS_NULL);
        }
        if (transmitOptions < 0 || transmitOptions > 255) {
            throw new IllegalArgumentException(ERROR_OPTIONS_INVALID);
        }
        if (command == null) {
            throw new NullPointerException(ERROR_AT_COMMAND_NULL);
        }
        this.frameID = frameID;
        this.destAddress = destAddress;
        this.transmitOptions = transmitOptions;
        this.command = command;
        this.parameter = parameter;
        this.logger = LoggerFactory.getLogger(RemoteATCommandWifiPacket.class);
    }

    public RemoteATCommandWifiPacket(int frameID, Inet4Address destAddress, int transmitOptions, String command, String parameter) {
        this(frameID, destAddress, transmitOptions, command, parameter == null ? null : parameter.getBytes());
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(new byte[]{0, 0, 0, 0});
            os.write(this.destAddress.getAddress());
            os.write(this.transmitOptions);
            os.write(this.command.getBytes());
            if (this.parameter != null) {
                os.write(this.parameter);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    @Override
    public boolean isBroadcast() {
        return this.destAddress.getHostAddress().equals("255.255.255.255");
    }

    public Inet4Address getDestinationAddress() {
        return this.destAddress;
    }

    public int getTransmitOptions() {
        return this.transmitOptions;
    }

    public String getCommand() {
        return this.command;
    }

    public void setParameter(String parameter) {
        this.parameter = (byte[])(parameter == null ? null : parameter.getBytes());
    }

    public void setParameter(byte[] parameter) {
        this.parameter = parameter;
    }

    public byte[] getParameter() {
        return this.parameter;
    }

    public String getParameterAsString() {
        if (this.parameter == null) {
            return null;
        }
        return new String(this.parameter);
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Destination address", "00 00 00 00 " + HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.destAddress.getAddress())) + " (" + this.destAddress.getHostAddress() + ")");
        parameters.put("Transmit options", HexUtils.prettyHexString(HexUtils.integerToHexString(this.transmitOptions, 1)));
        parameters.put("AT Command", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.command.getBytes())) + " (" + this.command + ")");
        if (this.parameter != null) {
            if (ATStringCommands.get(this.command) != null) {
                parameters.put("Parameter", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.parameter)) + " (" + new String(this.parameter) + ")");
            } else {
                parameters.put("Parameter", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.parameter)));
            }
        }
        return parameters;
    }
}

