/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.wifi;

import com.digi.xbee.api.models.ATCommandStatus;
import com.digi.xbee.api.models.ATStringCommands;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteATCommandResponseWifiPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 13;
    private static final String ERROR_PAYLOAD_NULL = "Remote AT Command Response (Wi-Fi) packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete Remote AT Command Response (Wi-Fi) packet.";
    private static final String ERROR_NOT_VALID_PACKET = "Payload is not a Remote AT Command Response (Wi-Fi) packet.";
    private static final String ERROR_FRAME_ID_ILLEGAL = "Frame ID must be between 0 and 255.";
    private static final String ERROR_SOURCE_ADDRESS_NULL = "Source address cannot be null.";
    private static final String ERROR_AT_COMMAND_NULL = "AT command cannot be null.";
    private static final String ERROR_STATUS_NULL = "AT command status cannot be null.";
    private final Inet4Address sourceAddress;
    private final ATCommandStatus status;
    private final String command;
    private byte[] commandValue;
    private Logger logger;

    public static RemoteATCommandResponseWifiPacket createPacket(byte[] payload) {
        Inet4Address sourceAddress;
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 13) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.REMOTE_AT_COMMAND_RESPONSE_WIFI.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_VALID_PACKET);
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        ++index;
        try {
            sourceAddress = (Inet4Address)Inet4Address.getByAddress(Arrays.copyOfRange(payload, index + 4, index + 8));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        String command = new String(new byte[]{payload[index += 8], payload[index + 1]});
        int status = payload[index += 2] & 0xFF;
        byte[] commandData = null;
        if (++index < payload.length) {
            commandData = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new RemoteATCommandResponseWifiPacket(frameID, sourceAddress, command, ATCommandStatus.get(status), commandData);
    }

    public RemoteATCommandResponseWifiPacket(int frameID, Inet4Address sourceAddress, String command, ATCommandStatus status, byte[] commandValue) {
        super(APIFrameType.REMOTE_AT_COMMAND_RESPONSE_WIFI);
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException(ERROR_FRAME_ID_ILLEGAL);
        }
        if (sourceAddress == null) {
            throw new NullPointerException(ERROR_SOURCE_ADDRESS_NULL);
        }
        if (command == null) {
            throw new NullPointerException(ERROR_AT_COMMAND_NULL);
        }
        if (status == null) {
            throw new NullPointerException(ERROR_STATUS_NULL);
        }
        this.frameID = frameID;
        this.sourceAddress = sourceAddress;
        this.command = command;
        this.status = status;
        this.commandValue = commandValue;
        this.logger = LoggerFactory.getLogger(RemoteATCommandResponseWifiPacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(new byte[]{0, 0, 0, 0});
            os.write(this.sourceAddress.getAddress());
            os.write(ByteUtils.stringToByteArray(this.command));
            os.write(this.status.getId());
            if (this.commandValue != null) {
                os.write(this.commandValue);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    public Inet4Address getSourceAddress() {
        return this.sourceAddress;
    }

    public ATCommandStatus getStatus() {
        return this.status;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommandValue(String commandValue) {
        this.commandValue = (byte[])(commandValue == null ? null : commandValue.getBytes());
    }

    public void setCommandValue(byte[] commandValue) {
        this.commandValue = commandValue;
    }

    public byte[] getCommandValue() {
        return this.commandValue;
    }

    public String getCommandValueAsString() {
        if (this.commandValue == null) {
            return null;
        }
        return new String(this.commandValue);
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Source address", "00 00 00 00 " + HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.sourceAddress.getAddress())) + " (" + this.sourceAddress.getHostAddress() + ")");
        parameters.put("AT Command", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.command.getBytes())) + " (" + this.command + ")");
        parameters.put("Status", HexUtils.prettyHexString(HexUtils.integerToHexString(this.status.getId(), 1)) + " (" + this.status.getDescription() + ")");
        if (this.commandValue != null) {
            if (ATStringCommands.get(this.command) != null) {
                parameters.put("Response", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.commandValue)) + " (" + new String(this.commandValue) + ")");
            } else {
                parameters.put("Response", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.commandValue)));
            }
        }
        return parameters;
    }
}

