/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.thread;

import com.digi.xbee.api.models.ATStringCommands;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPv6RemoteATCommandRequestPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 21;
    private static final String ERROR_PAYLOAD_NULL = "IPv6 Remote AT command packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete IPv6 Remote AT command packet.";
    private static final String ERROR_NOT_REMOTE_IPV6_REQ = "Payload is not an IPv6 Remote AT command packet.";
    private static final String ERROR_DEST_ADDR_NULL = "Destination address cannot be null.";
    private static final String ERROR_AT_CMD_NULL = "AT command cannot be null.";
    private static final String ERROR_FRAME_ID_ILLEGAL = "Frame ID must be between 0 and 255.";
    private static final String ERROR_OPTIONS_INVALID = "Transmit options can only be 2 or 0.";
    private static final String OPERATION_EXCEPTION = "Operation not supported in this module.";
    private final Inet6Address destAddress;
    private final int transmitOptions;
    private final String command;
    private byte[] parameter;
    private Logger logger;

    public static IPv6RemoteATCommandRequestPacket createPacket(byte[] payload) {
        Inet6Address destAddress;
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 21) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.IPV6_REMOTE_AT_COMMAND_REQUEST.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_REMOTE_IPV6_REQ);
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        ++index;
        try {
            destAddress = (Inet6Address)Inet6Address.getByAddress(Arrays.copyOfRange(payload, index, index + 16));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        int transmitOptions = payload[index += 16] & 0xFF;
        String command = new String(new byte[]{payload[++index], payload[index + 1]});
        byte[] parameterData = null;
        if ((index += 2) < payload.length) {
            parameterData = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new IPv6RemoteATCommandRequestPacket(frameID, destAddress, transmitOptions, command, parameterData);
    }

    public IPv6RemoteATCommandRequestPacket(int frameID, Inet6Address destAddress, int transmitOptions, String command, String parameter) {
        super(APIFrameType.IPV6_REMOTE_AT_COMMAND_REQUEST);
        if (destAddress == null) {
            throw new NullPointerException(ERROR_DEST_ADDR_NULL);
        }
        if (command == null) {
            throw new NullPointerException(ERROR_AT_CMD_NULL);
        }
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException(ERROR_FRAME_ID_ILLEGAL);
        }
        if (transmitOptions != 2 && transmitOptions != 0) {
            throw new IllegalArgumentException(ERROR_OPTIONS_INVALID);
        }
        this.frameID = frameID;
        this.destAddress = destAddress;
        this.transmitOptions = transmitOptions;
        this.command = command;
        if (parameter != null) {
            this.parameter = parameter.getBytes();
        }
        this.logger = LoggerFactory.getLogger(IPv6RemoteATCommandRequestPacket.class);
    }

    public IPv6RemoteATCommandRequestPacket(int frameID, Inet6Address destAddress, int transmitOptions, String command, byte[] parameter) {
        super(APIFrameType.IPV6_REMOTE_AT_COMMAND_REQUEST);
        if (destAddress == null) {
            throw new NullPointerException(ERROR_DEST_ADDR_NULL);
        }
        if (command == null) {
            throw new NullPointerException(ERROR_AT_CMD_NULL);
        }
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException(ERROR_FRAME_ID_ILLEGAL);
        }
        if (transmitOptions != 2 && transmitOptions != 0) {
            throw new IllegalArgumentException(ERROR_OPTIONS_INVALID);
        }
        this.frameID = frameID;
        this.destAddress = destAddress;
        this.transmitOptions = transmitOptions;
        this.command = command;
        this.parameter = parameter;
        this.logger = LoggerFactory.getLogger(IPv6RemoteATCommandRequestPacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            data.write(this.destAddress.getAddress());
            data.write(this.transmitOptions & 0xFF);
            data.write(ByteUtils.stringToByteArray(this.command));
            if (this.parameter != null) {
                data.write(this.parameter);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return data.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    @Override
    public boolean isBroadcast() {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    public Inet6Address getDestAddress() {
        return this.destAddress;
    }

    public int getTransmitOptions() {
        return this.transmitOptions;
    }

    public String getCommand() {
        return this.command;
    }

    public void setParameter(String parameter) {
        this.parameter = (byte[])(parameter == null ? null : parameter.getBytes());
    }

    public void setParameter(byte[] parameter) {
        this.parameter = parameter;
    }

    public byte[] getParameter() {
        return this.parameter;
    }

    public String getParameterAsString() {
        if (this.parameter == null) {
            return null;
        }
        return new String(this.parameter);
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Destination address", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.destAddress.getAddress())) + " (" + this.destAddress.getHostAddress() + ")");
        parameters.put("Command options", HexUtils.prettyHexString(HexUtils.integerToHexString(this.transmitOptions, 1)));
        parameters.put("AT Command", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.command.getBytes())) + " (" + this.command + ")");
        if (this.parameter != null) {
            if (ATStringCommands.get(this.command) != null) {
                parameters.put("Parameter", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.parameter)) + " (" + new String(this.parameter) + ")");
            } else {
                parameters.put("Parameter", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.parameter)));
            }
        }
        return parameters;
    }
}

