/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.raw;

import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TX64Packet
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 11;
    private final int transmitOptions;
    private final XBee64BitAddress destAddress64;
    private byte[] rfData;
    private Logger logger;

    public static TX64Packet createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("TX64 Request packet payload cannot be null.");
        }
        if (payload.length < 11) {
            throw new IllegalArgumentException("Incomplete TX64 Request packet.");
        }
        if ((payload[0] & 0xFF) != APIFrameType.TX_64.getValue()) {
            throw new IllegalArgumentException("Payload is not a TX64 Request packet.");
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        XBee64BitAddress destAddress64 = new XBee64BitAddress(Arrays.copyOfRange(payload, ++index, index + 8));
        int transmitOptions = payload[index += 8] & 0xFF;
        byte[] data = null;
        if (++index < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new TX64Packet(frameID, destAddress64, transmitOptions, data);
    }

    public TX64Packet(int frameID, XBee64BitAddress destAddress64, int transmitOptions, byte[] rfData) {
        super(APIFrameType.TX_64);
        if (destAddress64 == null) {
            throw new NullPointerException("64-bit destination address cannot be null.");
        }
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException("Frame ID must be between 0 and 255.");
        }
        if (transmitOptions < 0 || transmitOptions > 255) {
            throw new IllegalArgumentException("Transmit options must be between 0 and 255.");
        }
        this.frameID = frameID;
        this.destAddress64 = destAddress64;
        this.transmitOptions = transmitOptions;
        this.rfData = rfData;
        this.logger = LoggerFactory.getLogger(TX64Packet.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(this.destAddress64.getValue());
            os.write(this.transmitOptions);
            if (this.rfData != null) {
                os.write(this.rfData);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    @Override
    public boolean isBroadcast() {
        return this.get64bitDestinationAddress().equals(XBee64BitAddress.BROADCAST_ADDRESS);
    }

    public XBee64BitAddress get64bitDestinationAddress() {
        return this.destAddress64;
    }

    public int getTransmitOptions() {
        return this.transmitOptions;
    }

    public void setRFData(byte[] rfData) {
        this.rfData = (byte[])(rfData == null ? null : Arrays.copyOf(rfData, rfData.length));
    }

    public byte[] getRFData() {
        if (this.rfData == null) {
            return null;
        }
        return Arrays.copyOf(this.rfData, this.rfData.length);
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("64-bit dest. address", HexUtils.prettyHexString(this.destAddress64.toString()));
        parameters.put("Options", HexUtils.prettyHexString(HexUtils.integerToHexString(this.transmitOptions, 1)));
        if (this.rfData != null) {
            parameters.put("RF data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.rfData)));
        }
        return parameters;
    }
}

