/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.devicecloud;

import com.digi.xbee.api.models.SendDataRequestOptions;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendDataRequestPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 6;
    private static final String ERROR_PAYLOAD_NULL = "Send Data Request packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete Send Data Request packet.";
    private static final String ERROR_NOT_VALID = "Payload is not a Send Data Request packet.";
    private static final String ERROR_FRAME_ID_ILLEGAL = "Frame ID must be between 0 and 255.";
    private static final String ERROR_OPTIONS_NULL = "Options cannot be null.";
    private String path;
    private String contentType;
    private final int transport = 0;
    private SendDataRequestOptions options;
    private byte[] fileData;
    private Logger logger;

    public static SendDataRequestPacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 6) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.SEND_DATA_REQUEST.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_VALID);
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        int pathLength = payload[++index] & 0xFF;
        ++index;
        String path = null;
        if (pathLength > 0) {
            path = new String(Arrays.copyOfRange(payload, index, index + pathLength));
            index += pathLength;
        }
        int contentTypeLength = payload[index] & 0xFF;
        ++index;
        String contentType = null;
        if (contentTypeLength > 0) {
            contentType = new String(Arrays.copyOfRange(payload, index, index + contentTypeLength));
            index += contentTypeLength;
        }
        SendDataRequestOptions options = SendDataRequestOptions.get(payload[++index] & 0xFF);
        byte[] data = null;
        if (++index < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new SendDataRequestPacket(frameID, path, contentType, options, data);
    }

    public SendDataRequestPacket(int frameID, String path, String contentType, SendDataRequestOptions options, byte[] fileData) {
        super(APIFrameType.SEND_DATA_REQUEST);
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException(ERROR_FRAME_ID_ILLEGAL);
        }
        if (options == null) {
            throw new NullPointerException(ERROR_OPTIONS_NULL);
        }
        this.frameID = frameID;
        this.path = path;
        this.contentType = contentType;
        this.options = options;
        this.fileData = fileData;
        this.logger = LoggerFactory.getLogger(SendDataRequestPacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            if (this.path == null) {
                os.write(0);
            } else {
                os.write(this.path.length());
                os.write(this.path.getBytes());
            }
            if (this.contentType == null) {
                os.write(0);
            } else {
                os.write(this.contentType.length());
                os.write(this.contentType.getBytes());
            }
            os.write(0);
            os.write(this.options.getID());
            if (this.fileData != null) {
                os.write(this.fileData);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getTransport() {
        return 0;
    }

    public void setOptions(SendDataRequestOptions options) {
        if (options == null) {
            throw new NullPointerException(ERROR_OPTIONS_NULL);
        }
        this.options = options;
    }

    public SendDataRequestOptions getOptions() {
        return this.options;
    }

    public void setFileData(byte[] fileData) {
        this.fileData = fileData;
    }

    public byte[] getFileData() {
        return this.fileData;
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (this.path != null) {
            parameters.put("Path length", HexUtils.prettyHexString(HexUtils.integerToHexString(this.path.length(), 1)) + " (" + this.path.length() + ")");
            parameters.put("Path", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.path.getBytes())) + " (" + this.path + ")");
        } else {
            parameters.put("Path length", HexUtils.prettyHexString(HexUtils.integerToHexString(0, 1)) + " (0)");
        }
        if (this.contentType != null) {
            parameters.put("Content Type length", HexUtils.prettyHexString(HexUtils.integerToHexString(this.contentType.length(), 1)) + " (" + this.contentType.length() + ")");
            parameters.put("Content Type", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.contentType.getBytes())) + " (" + this.contentType + ")");
        } else {
            parameters.put("Content Type length", HexUtils.prettyHexString(HexUtils.integerToHexString(0, 1)) + " (0)");
        }
        parameters.put("Transport", HexUtils.prettyHexString(HexUtils.integerToHexString(0, 1)));
        parameters.put("Options", HexUtils.prettyHexString(HexUtils.integerToHexString(this.options.getID(), 1)) + " (" + this.options.getName() + ")");
        if (this.fileData != null) {
            parameters.put("Data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.fileData)));
        }
        return parameters;
    }
}

