/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.devicecloud;

import com.digi.xbee.api.models.FrameError;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.util.LinkedHashMap;

public class FrameErrorPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 2;
    private static final String ERROR_PAYLOAD_NULL = "Frame Error packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete Frame Error packet.";
    private static final String ERROR_NOT_VALID = "Payload is not a Frame Error packet.";
    private static final String ERROR_STATUS_NULL = "Frame error cannot be null.";
    private FrameError error;

    public static FrameErrorPacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 2) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.FRAME_ERROR.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_VALID);
        }
        int index = 1;
        FrameError error = FrameError.get(payload[index] & 0xFF);
        return new FrameErrorPacket(error);
    }

    public FrameErrorPacket(FrameError error) {
        super(APIFrameType.FRAME_ERROR);
        if (error == null) {
            throw new NullPointerException(ERROR_STATUS_NULL);
        }
        this.error = error;
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(this.error.getID());
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return false;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    public void setError(FrameError error) {
        if (error == null) {
            throw new NullPointerException(ERROR_STATUS_NULL);
        }
        this.error = error;
    }

    public FrameError getError() {
        return this.error;
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Error", HexUtils.prettyHexString(HexUtils.integerToHexString(this.error.getID(), 1)) + " (" + this.error.getName() + ")");
        return parameters;
    }
}

