/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.common;

import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBeeDiscoveryStatus;
import com.digi.xbee.api.models.XBeeTransmitStatus;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransmitStatusPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 7;
    private final XBee16BitAddress destAddress16;
    private final int tranmistRetryCount;
    private final XBeeTransmitStatus transmitStatus;
    private final XBeeDiscoveryStatus discoveryStatus;
    private Logger logger;

    public static TransmitStatusPacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("Transmit Status packet payload cannot be null.");
        }
        if (payload.length < 7) {
            throw new IllegalArgumentException("Incomplete Transmit Status packet.");
        }
        if ((payload[0] & 0xFF) != APIFrameType.TRANSMIT_STATUS.getValue()) {
            throw new IllegalArgumentException("Payload is not a Transmit Status packet.");
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        XBee16BitAddress address = new XBee16BitAddress(payload[++index] & 0xFF, payload[index + 1] & 0xFF);
        int retryCount = payload[index += 2] & 0xFF;
        int deliveryStatus = payload[++index] & 0xFF;
        int discoveryStatus = payload[++index] & 0xFF;
        return new TransmitStatusPacket(frameID, address, retryCount, XBeeTransmitStatus.get(deliveryStatus), XBeeDiscoveryStatus.get(discoveryStatus));
    }

    public TransmitStatusPacket(int frameID, XBee16BitAddress destAddress16, int tranmistRetryCount, XBeeTransmitStatus transmitStatus, XBeeDiscoveryStatus discoveryStatus) {
        super(APIFrameType.TRANSMIT_STATUS);
        if (destAddress16 == null) {
            throw new NullPointerException("16-bit destination address cannot be null.");
        }
        if (transmitStatus == null) {
            throw new NullPointerException("Delivery status cannot be null.");
        }
        if (discoveryStatus == null) {
            throw new NullPointerException("Discovery status cannot be null.");
        }
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException("Frame ID must be between 0 and 255.");
        }
        if (tranmistRetryCount < 0 || tranmistRetryCount > 255) {
            throw new IllegalArgumentException("Transmit retry count must be between 0 and 255.");
        }
        this.frameID = frameID;
        this.destAddress16 = destAddress16;
        this.tranmistRetryCount = tranmistRetryCount;
        this.transmitStatus = transmitStatus;
        this.discoveryStatus = discoveryStatus;
        this.logger = LoggerFactory.getLogger(TransmitStatusPacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            data.write(this.destAddress16.getValue());
            data.write(this.tranmistRetryCount);
            data.write(this.transmitStatus.getId());
            data.write(this.discoveryStatus.getId());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return data.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    public XBee16BitAddress get16bitDestinationAddress() {
        return this.destAddress16;
    }

    public int getTransmitRetryCount() {
        return this.tranmistRetryCount;
    }

    public XBeeTransmitStatus getTransmitStatus() {
        return this.transmitStatus;
    }

    public XBeeDiscoveryStatus getDiscoveryStatus() {
        return this.discoveryStatus;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("16-bit dest. address", HexUtils.prettyHexString(this.destAddress16.toString()));
        parameters.put("Tx. retry count", HexUtils.prettyHexString(HexUtils.integerToHexString(this.tranmistRetryCount, 1)) + " (" + this.tranmistRetryCount + ")");
        parameters.put("Delivery status", HexUtils.prettyHexString(HexUtils.integerToHexString(this.transmitStatus.getId(), 1)) + " (" + this.transmitStatus.getDescription() + ")");
        parameters.put("Discovery status", HexUtils.prettyHexString(HexUtils.integerToHexString(this.discoveryStatus.getId(), 1)) + " (" + this.discoveryStatus.getDescription() + ")");
        return parameters;
    }
}

