/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.common;

import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransmitPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 14;
    private final XBee64BitAddress destAddress64;
    private final XBee16BitAddress destAddress16;
    private final int broadcastRadius;
    private final int transmitOptions;
    private byte[] rfData;
    private Logger logger;

    public static TransmitPacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("Transmit packet payload cannot be null.");
        }
        if (payload.length < 14) {
            throw new IllegalArgumentException("Incomplete Transmit packet.");
        }
        if ((payload[0] & 0xFF) != APIFrameType.TRANSMIT_REQUEST.getValue()) {
            throw new IllegalArgumentException("Payload is not a Transmit packet.");
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        XBee64BitAddress destAddress64 = new XBee64BitAddress(Arrays.copyOfRange(payload, ++index, index + 8));
        XBee16BitAddress destAddress16 = new XBee16BitAddress(payload[index += 8] & 0xFF, payload[index + 1] & 0xFF);
        int broadcastRadius = payload[index += 2] & 0xFF;
        int options = payload[++index] & 0xFF;
        byte[] rfData = null;
        if (++index < payload.length) {
            rfData = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new TransmitPacket(frameID, destAddress64, destAddress16, broadcastRadius, options, rfData);
    }

    public TransmitPacket(int frameID, XBee64BitAddress destAddress64, XBee16BitAddress destAddress16, int broadcastRadius, int transmitOptions, byte[] rfData) {
        super(APIFrameType.TRANSMIT_REQUEST);
        if (destAddress64 == null) {
            throw new NullPointerException("64-bit destination address cannot be null.");
        }
        if (destAddress16 == null) {
            throw new NullPointerException("16-bit destination address cannot be null.");
        }
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException("Frame ID must be between 0 and 255.");
        }
        if (broadcastRadius < 0 || broadcastRadius > 255) {
            throw new IllegalArgumentException("Broadcast radius must be between 0 and 255.");
        }
        if (transmitOptions < 0 || transmitOptions > 255) {
            throw new IllegalArgumentException("Transmit options must be between 0 and 255.");
        }
        this.frameID = frameID;
        this.destAddress64 = destAddress64;
        this.destAddress16 = destAddress16;
        this.broadcastRadius = broadcastRadius;
        this.transmitOptions = transmitOptions;
        this.rfData = rfData;
        this.logger = LoggerFactory.getLogger(TransmitPacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            data.write(this.destAddress64.getValue());
            data.write(this.destAddress16.getValue());
            data.write(this.broadcastRadius);
            data.write(this.transmitOptions);
            if (this.rfData != null) {
                data.write(this.rfData);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return data.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    @Override
    public boolean isBroadcast() {
        return this.get64bitDestinationAddress().equals(XBee64BitAddress.BROADCAST_ADDRESS) || this.get16bitDestinationAddress().equals(XBee16BitAddress.BROADCAST_ADDRESS);
    }

    public XBee64BitAddress get64bitDestinationAddress() {
        return this.destAddress64;
    }

    public XBee16BitAddress get16bitDestinationAddress() {
        return this.destAddress16;
    }

    public int getBroadcastRadius() {
        return this.broadcastRadius;
    }

    public int getTransmitOptions() {
        return this.transmitOptions;
    }

    public void setRFData(byte[] rfData) {
        this.rfData = (byte[])(rfData == null ? null : Arrays.copyOf(rfData, rfData.length));
    }

    public byte[] getRFData() {
        if (this.rfData == null) {
            return null;
        }
        return Arrays.copyOf(this.rfData, this.rfData.length);
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("64-bit dest. address", HexUtils.prettyHexString(this.destAddress64.toString()));
        parameters.put("16-bit dest. address", HexUtils.prettyHexString(this.destAddress16.toString()));
        parameters.put("Broadcast radius", HexUtils.prettyHexString(HexUtils.integerToHexString(this.broadcastRadius, 1)) + " (" + this.broadcastRadius + ")");
        parameters.put("Options", HexUtils.prettyHexString(HexUtils.integerToHexString(this.transmitOptions, 1)));
        if (this.rfData != null) {
            parameters.put("RF data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.rfData)));
        }
        return parameters;
    }
}

