/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.common;

import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplicitRxIndicatorPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 18;
    public static final int DATA_ENDPOINT = 232;
    public static final int DATA_CLUSTER = 17;
    public static final int DIGI_PROFILE = 49413;
    private final XBee64BitAddress sourceAddress64;
    private final XBee16BitAddress sourceAddress16;
    private final int sourceEndpoint;
    private final int destEndpoint;
    private final int clusterID;
    private final int profileID;
    private final int receiveOptions;
    private byte[] rfData;
    private Logger logger;

    public static ExplicitRxIndicatorPacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("Explicit Rx Indicator packet payload cannot be null.");
        }
        if (payload.length < 18) {
            throw new IllegalArgumentException("Incomplete Explicit Rx Indicator packet.");
        }
        if ((payload[0] & 0xFF) != APIFrameType.EXPLICIT_RX_INDICATOR.getValue()) {
            throw new IllegalArgumentException("Payload is not an Explicit Rx Indicator packet.");
        }
        int index = 1;
        XBee64BitAddress destAddress64 = new XBee64BitAddress(Arrays.copyOfRange(payload, index, index + 8));
        XBee16BitAddress destAddress16 = new XBee16BitAddress(payload[index += 8] & 0xFF, payload[index + 1] & 0xFF);
        int sourceEndpoint = payload[index += 2] & 0xFF;
        int destEndpoint = payload[++index] & 0xFF;
        int clusterID = (payload[++index] & 0xFF) << 8 | payload[index + 1] & 0xFF;
        int profileID = (payload[index += 2] & 0xFF) << 8 | payload[index + 1] & 0xFF;
        int receiveOptions = payload[index += 2] & 0xFF;
        byte[] rfData = null;
        if (++index < payload.length) {
            rfData = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new ExplicitRxIndicatorPacket(destAddress64, destAddress16, sourceEndpoint, destEndpoint, clusterID, profileID, receiveOptions, rfData);
    }

    public ExplicitRxIndicatorPacket(XBee64BitAddress sourceAddress64, XBee16BitAddress sourceAddress16, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, int receiveOptions, byte[] rfData) {
        super(APIFrameType.EXPLICIT_RX_INDICATOR);
        if (sourceAddress64 == null) {
            throw new NullPointerException("64-bit source address cannot be null.");
        }
        if (sourceAddress16 == null) {
            throw new NullPointerException("16-bit source address cannot be null.");
        }
        if (sourceEndpoint < 0 || sourceEndpoint > 255) {
            throw new IllegalArgumentException("Source endpoint must be between 0 and 255.");
        }
        if (destEndpoint < 0 || destEndpoint > 255) {
            throw new IllegalArgumentException("Destination endpoint must be between 0 and 255.");
        }
        if (clusterID < 0 || clusterID > 65535) {
            throw new IllegalArgumentException("Cluster ID must be between 0 and 65535.");
        }
        if (profileID < 0 || profileID > 65535) {
            throw new IllegalArgumentException("Profile ID must be between 0 and 65535.");
        }
        if (receiveOptions < 0 || receiveOptions > 255) {
            throw new IllegalArgumentException("Receive options must be between 0 and 255.");
        }
        this.sourceAddress64 = sourceAddress64;
        this.sourceAddress16 = sourceAddress16;
        this.sourceEndpoint = sourceEndpoint;
        this.destEndpoint = destEndpoint;
        this.clusterID = clusterID;
        this.profileID = profileID;
        this.receiveOptions = receiveOptions;
        this.rfData = rfData;
        this.logger = LoggerFactory.getLogger(ExplicitRxIndicatorPacket.class);
    }

    @Override
    public byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            data.write(this.sourceAddress64.getValue());
            data.write(this.sourceAddress16.getValue());
            data.write(this.sourceEndpoint);
            data.write(this.destEndpoint);
            data.write(this.clusterID >> 8);
            data.write(this.clusterID);
            data.write(this.profileID >> 8);
            data.write(this.profileID);
            data.write(this.receiveOptions);
            if (this.rfData != null) {
                data.write(this.rfData);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return data.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return false;
    }

    @Override
    public boolean isBroadcast() {
        return ByteUtils.isBitEnabled(this.getReceiveOptions(), 1);
    }

    public XBee64BitAddress get64BitSourceAddress() {
        return this.sourceAddress64;
    }

    public XBee16BitAddress get16BitSourceAddress() {
        return this.sourceAddress16;
    }

    public int getSourceEndpoint() {
        return this.sourceEndpoint;
    }

    public int getDestinationEndpoint() {
        return this.destEndpoint;
    }

    public int getClusterID() {
        return this.clusterID;
    }

    public int getProfileID() {
        return this.profileID;
    }

    public int getReceiveOptions() {
        return this.receiveOptions;
    }

    public void setRFData(byte[] rfData) {
        this.rfData = (byte[])(rfData == null ? null : Arrays.copyOf(rfData, rfData.length));
    }

    public byte[] getRFData() {
        if (this.rfData == null) {
            return null;
        }
        return Arrays.copyOf(this.rfData, this.rfData.length);
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("64-bit source address", HexUtils.prettyHexString(this.sourceAddress64.toString()));
        parameters.put("16-bit source address", HexUtils.prettyHexString(this.sourceAddress16.toString()));
        parameters.put("Source endpoint", HexUtils.prettyHexString(HexUtils.integerToHexString(this.sourceEndpoint, 1)));
        parameters.put("Dest. endpoint", HexUtils.prettyHexString(HexUtils.integerToHexString(this.destEndpoint, 1)));
        parameters.put("Cluster ID", HexUtils.prettyHexString(HexUtils.integerToHexString(this.clusterID, 2)));
        parameters.put("Profile ID", HexUtils.prettyHexString(HexUtils.integerToHexString(this.profileID, 2)));
        parameters.put("Receive options", HexUtils.prettyHexString(HexUtils.integerToHexString(this.receiveOptions, 1)));
        if (this.rfData != null) {
            parameters.put("RF data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.rfData)));
        }
        return parameters;
    }
}

