/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.common;

import com.digi.xbee.api.models.ATCommandStatus;
import com.digi.xbee.api.models.ATStringCommands;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ATCommandResponsePacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 5;
    private final ATCommandStatus status;
    private final String command;
    private byte[] commandValue;
    private Logger logger;

    public static ATCommandResponsePacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("AT Command Response packet payload cannot be null.");
        }
        if (payload.length < 5) {
            throw new IllegalArgumentException("Incomplete AT Command Response packet.");
        }
        if ((payload[0] & 0xFF) != APIFrameType.AT_COMMAND_RESPONSE.getValue()) {
            throw new IllegalArgumentException("Payload is not an AT Command Response packet.");
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        String command = new String(new byte[]{payload[++index], payload[index + 1]});
        int status = payload[index += 2] & 0xFF;
        byte[] commandData = null;
        if (++index < payload.length) {
            commandData = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new ATCommandResponsePacket(frameID, ATCommandStatus.get(status), command, commandData);
    }

    public ATCommandResponsePacket(int frameID, ATCommandStatus status, String command, byte[] commandValue) {
        super(APIFrameType.AT_COMMAND_RESPONSE);
        if (command == null) {
            throw new NullPointerException("AT command cannot be null.");
        }
        if (status == null) {
            throw new NullPointerException("AT command status cannot be null.");
        }
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException("Frame ID must be between 0 and 255.");
        }
        this.frameID = frameID;
        this.status = status;
        this.command = command;
        this.commandValue = commandValue;
        this.logger = LoggerFactory.getLogger(ATCommandResponsePacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(this.command.getBytes());
            os.write(this.status.getId());
            if (this.commandValue != null) {
                os.write(this.commandValue);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    public ATCommandStatus getStatus() {
        return this.status;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommandValue(String commandValue) {
        this.commandValue = (byte[])(commandValue == null ? null : commandValue.getBytes());
    }

    public void setCommandValue(byte[] commandValue) {
        this.commandValue = commandValue;
    }

    public byte[] getCommandValue() {
        return this.commandValue;
    }

    public String getCommandValueAsString() {
        if (this.commandValue == null) {
            return null;
        }
        return new String(this.commandValue);
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("AT Command", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.command.getBytes())) + " (" + this.command + ")");
        parameters.put("Status", HexUtils.prettyHexString(HexUtils.integerToHexString(this.status.getId(), 1)) + " (" + this.status.getDescription() + ")");
        if (this.commandValue != null) {
            if (ATStringCommands.get(this.command) != null) {
                parameters.put("Response", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.commandValue)) + " (" + new String(this.commandValue) + ")");
            } else {
                parameters.put("Response", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.commandValue)));
            }
        }
        return parameters;
    }
}

