/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.cellular;

import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TXSMSPacket
extends XBeeAPIPacket {
    static final int PHONE_NUMBER_LENGTH = 20;
    static final String PHONE_NUMBER_PATTERN = "^\\+?\\d+$";
    static final String ERROR_PHONE_NUMBER_LENGTH = "Phone number length cannot be greater than 20 bytes.";
    static final String ERROR_PHONE_NUMBER_NULL = "Phone number cannot be null.";
    static final String ERROR_PHONE_NUMBER_INVALID = "Phone number invalid, only numbers and '+' prefix allowed.";
    private static final int MIN_API_PAYLOAD_LENGTH = 23;
    private static final String ERROR_PAYLOAD_NULL = "TX SMS packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete TX SMS packet.";
    private static final String ERROR_NOT_TXSMS = "Payload is not a TX SMS packet.";
    private static final String ERROR_FRAME_ID_ILLEGAL = "Frame ID must be between 0 and 255.";
    private int transmitOptions = 0;
    private byte[] phoneNumber;
    private String data;
    private Logger logger;

    public static TXSMSPacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 23) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.TX_SMS.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_TXSMS);
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        ++index;
        byte[] phoneNumber = Arrays.copyOfRange(payload, ++index, index + 20);
        byte[] data = null;
        if ((index += 20) < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new TXSMSPacket(frameID, new String(phoneNumber).replace("\u0000", ""), data == null ? null : new String(data));
    }

    public TXSMSPacket(int frameID, String phoneNumber, String data) {
        super(APIFrameType.TX_SMS);
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException(ERROR_FRAME_ID_ILLEGAL);
        }
        if (phoneNumber == null) {
            throw new NullPointerException(ERROR_PHONE_NUMBER_NULL);
        }
        if (phoneNumber.length() > 20) {
            throw new IllegalArgumentException(ERROR_PHONE_NUMBER_LENGTH);
        }
        if (!Pattern.matches(PHONE_NUMBER_PATTERN, phoneNumber)) {
            throw new IllegalArgumentException(ERROR_PHONE_NUMBER_INVALID);
        }
        this.frameID = frameID;
        this.phoneNumber = Arrays.copyOf(phoneNumber.getBytes(), 20);
        this.data = data;
        this.logger = LoggerFactory.getLogger(TXSMSPacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write((byte)this.transmitOptions);
            os.write(this.phoneNumber);
            if (this.data != null) {
                os.write(this.data.getBytes());
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    public void setPhoneNumber(String phoneNumber) {
        if (phoneNumber == null) {
            throw new NullPointerException(ERROR_PHONE_NUMBER_NULL);
        }
        if (phoneNumber.length() > 20) {
            throw new IllegalArgumentException(ERROR_PHONE_NUMBER_LENGTH);
        }
        if (!Pattern.matches(PHONE_NUMBER_PATTERN, phoneNumber)) {
            throw new IllegalArgumentException(ERROR_PHONE_NUMBER_INVALID);
        }
        this.phoneNumber = Arrays.copyOf(phoneNumber.getBytes(), 20);
    }

    public byte[] getPhoneNumberByteArray() {
        return this.phoneNumber;
    }

    public String getPhoneNumber() {
        return new String(this.phoneNumber).replace("\u0000", "");
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getData() {
        return this.data;
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Transmit options", HexUtils.prettyHexString(HexUtils.integerToHexString(this.transmitOptions, 1)));
        parameters.put("Phone number", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.phoneNumber)) + " (" + new String(this.phoneNumber).replaceAll("\u0000", "") + ")");
        if (this.data != null) {
            parameters.put("Data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.data.getBytes())) + " (" + this.data + ")");
        }
        return parameters;
    }
}

