/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.cellular;

import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RXSMSPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 21;
    private static final String ERROR_PAYLOAD_NULL = "RX SMS packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete RX SMS packet.";
    private static final String ERROR_NOT_RXSMS = "Payload is not a RX SMS packet.";
    private byte[] phoneNumber;
    private String data;
    private Logger logger;

    public static RXSMSPacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 21) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.RX_SMS.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_RXSMS);
        }
        int index = 1;
        byte[] phoneNumber = Arrays.copyOfRange(payload, index, index + 20);
        byte[] data = null;
        if ((index += 20) < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new RXSMSPacket(new String(phoneNumber).replaceAll("\u0000", ""), data == null ? null : new String(data));
    }

    public RXSMSPacket(String phoneNumber, String data) {
        super(APIFrameType.RX_SMS);
        if (phoneNumber == null) {
            throw new NullPointerException("Phone number cannot be null.");
        }
        if (phoneNumber.length() > 20) {
            throw new IllegalArgumentException("Phone number length cannot be greater than 20 bytes.");
        }
        if (!Pattern.matches("^\\+?\\d+$", phoneNumber)) {
            throw new IllegalArgumentException("Phone number invalid, only numbers and '+' prefix allowed.");
        }
        this.phoneNumber = Arrays.copyOf(phoneNumber.getBytes(), 20);
        this.data = data;
        this.logger = LoggerFactory.getLogger(RXSMSPacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(this.phoneNumber);
            if (this.data != null) {
                os.write(this.data.getBytes());
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return false;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    public void setPhoneNumber(String phoneNumber) {
        if (phoneNumber == null) {
            throw new NullPointerException("Phone number cannot be null.");
        }
        if (phoneNumber.length() > 20) {
            throw new IllegalArgumentException("Phone number length cannot be greater than 20 bytes.");
        }
        if (!Pattern.matches("^\\+?\\d+$", phoneNumber)) {
            throw new IllegalArgumentException("Phone number invalid, only numbers and '+' prefix allowed.");
        }
        this.phoneNumber = Arrays.copyOf(phoneNumber.getBytes(), 20);
    }

    public byte[] getPhoneNumberByteArray() {
        return this.phoneNumber;
    }

    public String getPhoneNumber() {
        return new String(this.phoneNumber).replace("\u0000", "");
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getData() {
        return this.data;
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Phone number", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.phoneNumber)) + " (" + new String(this.phoneNumber).replaceAll("\u0000", "") + ")");
        if (this.data != null) {
            parameters.put("Data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.data.getBytes())) + " (" + this.data + ")");
        }
        return parameters;
    }
}

