/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet;

import com.digi.xbee.api.exceptions.InvalidPacketException;
import com.digi.xbee.api.models.OperatingMode;
import com.digi.xbee.api.models.SpecialByte;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.GenericXBeePacket;
import com.digi.xbee.api.packet.UnknownXBeePacket;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.packet.XBeeChecksum;
import com.digi.xbee.api.packet.XBeePacket;
import com.digi.xbee.api.packet.cellular.RXSMSPacket;
import com.digi.xbee.api.packet.cellular.TXSMSPacket;
import com.digi.xbee.api.packet.common.ATCommandPacket;
import com.digi.xbee.api.packet.common.ATCommandQueuePacket;
import com.digi.xbee.api.packet.common.ATCommandResponsePacket;
import com.digi.xbee.api.packet.common.ExplicitAddressingPacket;
import com.digi.xbee.api.packet.common.ExplicitRxIndicatorPacket;
import com.digi.xbee.api.packet.common.IODataSampleRxIndicatorPacket;
import com.digi.xbee.api.packet.common.ModemStatusPacket;
import com.digi.xbee.api.packet.common.ReceivePacket;
import com.digi.xbee.api.packet.common.RemoteATCommandPacket;
import com.digi.xbee.api.packet.common.RemoteATCommandResponsePacket;
import com.digi.xbee.api.packet.common.TransmitPacket;
import com.digi.xbee.api.packet.common.TransmitStatusPacket;
import com.digi.xbee.api.packet.devicecloud.DeviceRequestPacket;
import com.digi.xbee.api.packet.devicecloud.DeviceResponsePacket;
import com.digi.xbee.api.packet.devicecloud.DeviceResponseStatusPacket;
import com.digi.xbee.api.packet.devicecloud.FrameErrorPacket;
import com.digi.xbee.api.packet.devicecloud.SendDataRequestPacket;
import com.digi.xbee.api.packet.devicecloud.SendDataResponsePacket;
import com.digi.xbee.api.packet.ip.RXIPv4Packet;
import com.digi.xbee.api.packet.ip.TXIPv4Packet;
import com.digi.xbee.api.packet.raw.RX16IOPacket;
import com.digi.xbee.api.packet.raw.RX16Packet;
import com.digi.xbee.api.packet.raw.RX64IOPacket;
import com.digi.xbee.api.packet.raw.RX64Packet;
import com.digi.xbee.api.packet.raw.TX16Packet;
import com.digi.xbee.api.packet.raw.TX64Packet;
import com.digi.xbee.api.packet.raw.TXStatusPacket;
import com.digi.xbee.api.packet.thread.CoAPRxResponsePacket;
import com.digi.xbee.api.packet.thread.CoAPTxRequestPacket;
import com.digi.xbee.api.packet.thread.IPv6IODataSampleRxIndicator;
import com.digi.xbee.api.packet.thread.IPv6RemoteATCommandRequestPacket;
import com.digi.xbee.api.packet.thread.IPv6RemoteATCommandResponsePacket;
import com.digi.xbee.api.packet.thread.RXIPv6Packet;
import com.digi.xbee.api.packet.thread.TXIPv6Packet;
import com.digi.xbee.api.packet.wifi.IODataSampleRxIndicatorWifiPacket;
import com.digi.xbee.api.packet.wifi.RemoteATCommandResponseWifiPacket;
import com.digi.xbee.api.packet.wifi.RemoteATCommandWifiPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class XBeePacketParser {
    public XBeePacket parsePacket(InputStream inputStream, OperatingMode mode) throws InvalidPacketException {
        if (inputStream == null) {
            throw new NullPointerException("Input stream cannot be null.");
        }
        if (mode == null) {
            throw new NullPointerException("Operating mode cannot be null.");
        }
        if (mode != OperatingMode.API && mode != OperatingMode.API_ESCAPE) {
            throw new IllegalArgumentException("Operating mode must be API or API Escaped.");
        }
        try {
            int hSize = this.readByte(inputStream, mode);
            int lSize = this.readByte(inputStream, mode);
            int length = hSize << 8 | lSize;
            byte[] payload = this.readBytes(inputStream, mode, length);
            XBeeChecksum checksum = new XBeeChecksum();
            checksum.add(payload);
            byte expectedChecksum = (byte)(checksum.generate() & 0xFF);
            byte readChecksum = (byte)(this.readByte(inputStream, mode) & 0xFF);
            if (readChecksum != expectedChecksum) {
                throw new InvalidPacketException("Invalid checksum (expected 0x" + HexUtils.byteToHexString(expectedChecksum) + ").");
            }
            return this.parsePayload(payload);
        }
        catch (IOException e) {
            throw new InvalidPacketException("Error parsing packet: " + e.getMessage(), e);
        }
    }

    public XBeePacket parsePacket(byte[] packetByteArray, OperatingMode mode) throws InvalidPacketException {
        if (packetByteArray == null) {
            throw new NullPointerException("Packet byte array cannot be null.");
        }
        if (mode == null) {
            throw new NullPointerException("Operating mode cannot be null.");
        }
        if (mode != OperatingMode.API && mode != OperatingMode.API_ESCAPE) {
            throw new IllegalArgumentException("Operating mode must be API or API Escaped.");
        }
        if (packetByteArray.length < 4) {
            throw new InvalidPacketException("Error parsing packet: Incomplete packet.");
        }
        if ((packetByteArray[0] & 0xFF) != SpecialByte.HEADER_BYTE.getValue()) {
            throw new InvalidPacketException("Invalid start delimiter (expected 0x" + HexUtils.byteToHexString((byte)SpecialByte.HEADER_BYTE.getValue()) + ").");
        }
        return this.parsePacket(new ByteArrayInputStream(packetByteArray, 1, packetByteArray.length - 1), mode);
    }

    private XBeePacket parsePayload(byte[] payload) throws InvalidPacketException {
        APIFrameType apiType = APIFrameType.get(payload[0] & 0xFF);
        if (apiType == null) {
            return UnknownXBeePacket.createPacket(payload);
        }
        XBeeAPIPacket packet = null;
        switch (apiType) {
            case TX_64: {
                packet = TX64Packet.createPacket(payload);
                break;
            }
            case TX_16: {
                packet = TX16Packet.createPacket(payload);
                break;
            }
            case REMOTE_AT_COMMAND_REQUEST_WIFI: {
                packet = RemoteATCommandWifiPacket.createPacket(payload);
                break;
            }
            case AT_COMMAND: {
                packet = ATCommandPacket.createPacket(payload);
                break;
            }
            case AT_COMMAND_QUEUE: {
                packet = ATCommandQueuePacket.createPacket(payload);
                break;
            }
            case TRANSMIT_REQUEST: {
                packet = TransmitPacket.createPacket(payload);
                break;
            }
            case EXPLICIT_ADDRESSING_COMMAND_FRAME: {
                packet = ExplicitAddressingPacket.createPacket(payload);
                break;
            }
            case REMOTE_AT_COMMAND_REQUEST: {
                packet = RemoteATCommandPacket.createPacket(payload);
                break;
            }
            case IPV6_REMOTE_AT_COMMAND_REQUEST: {
                packet = IPv6RemoteATCommandRequestPacket.createPacket(payload);
                break;
            }
            case TX_SMS: {
                packet = TXSMSPacket.createPacket(payload);
                break;
            }
            case TX_IPV4: {
                packet = TXIPv4Packet.createPacket(payload);
                break;
            }
            case TX_IPV6: {
                packet = TXIPv6Packet.createPacket(payload);
                break;
            }
            case SEND_DATA_REQUEST: {
                packet = SendDataRequestPacket.createPacket(payload);
                break;
            }
            case DEVICE_RESPONSE: {
                packet = DeviceResponsePacket.createPacket(payload);
                break;
            }
            case RX_64: {
                packet = RX64Packet.createPacket(payload);
                break;
            }
            case RX_16: {
                packet = RX16Packet.createPacket(payload);
                break;
            }
            case RX_IPV6: {
                packet = RXIPv6Packet.createPacket(payload);
                break;
            }
            case RX_IO_64: {
                packet = RX64IOPacket.createPacket(payload);
                break;
            }
            case RX_IO_16: {
                packet = RX16IOPacket.createPacket(payload);
                break;
            }
            case REMOTE_AT_COMMAND_RESPONSE_WIFI: {
                packet = RemoteATCommandResponseWifiPacket.createPacket(payload);
                break;
            }
            case AT_COMMAND_RESPONSE: {
                packet = ATCommandResponsePacket.createPacket(payload);
                break;
            }
            case TX_STATUS: {
                packet = TXStatusPacket.createPacket(payload);
                break;
            }
            case MODEM_STATUS: {
                packet = ModemStatusPacket.createPacket(payload);
                break;
            }
            case TRANSMIT_STATUS: {
                packet = TransmitStatusPacket.createPacket(payload);
                break;
            }
            case IO_DATA_SAMPLE_RX_INDICATOR_WIFI: {
                packet = IODataSampleRxIndicatorWifiPacket.createPacket(payload);
                break;
            }
            case RECEIVE_PACKET: {
                packet = ReceivePacket.createPacket(payload);
                break;
            }
            case EXPLICIT_RX_INDICATOR: {
                packet = ExplicitRxIndicatorPacket.createPacket(payload);
                break;
            }
            case IO_DATA_SAMPLE_RX_INDICATOR: {
                packet = IODataSampleRxIndicatorPacket.createPacket(payload);
                break;
            }
            case IPV6_IO_DATA_SAMPLE_RX_INDICATOR: {
                packet = IPv6IODataSampleRxIndicator.createPacket(payload);
                break;
            }
            case REMOTE_AT_COMMAND_RESPONSE: {
                packet = RemoteATCommandResponsePacket.createPacket(payload);
                break;
            }
            case IPV6_REMOTE_AT_COMMAND_RESPONSE: {
                packet = IPv6RemoteATCommandResponsePacket.createPacket(payload);
                break;
            }
            case RX_SMS: {
                packet = RXSMSPacket.createPacket(payload);
                break;
            }
            case RX_IPV4: {
                packet = RXIPv4Packet.createPacket(payload);
                break;
            }
            case SEND_DATA_RESPONSE: {
                packet = SendDataResponsePacket.createPacket(payload);
                break;
            }
            case DEVICE_REQUEST: {
                packet = DeviceRequestPacket.createPacket(payload);
                break;
            }
            case DEVICE_RESPONSE_STATUS: {
                packet = DeviceResponseStatusPacket.createPacket(payload);
                break;
            }
            case COAP_TX_REQUEST: {
                packet = CoAPTxRequestPacket.createPacket(payload);
                break;
            }
            case COAP_RX_RESPONSE: {
                packet = CoAPRxResponsePacket.createPacket(payload);
                break;
            }
            case FRAME_ERROR: {
                packet = FrameErrorPacket.createPacket(payload);
                break;
            }
            case GENERIC: {
                packet = GenericXBeePacket.createPacket(payload);
                break;
            }
            default: {
                packet = UnknownXBeePacket.createPacket(payload);
            }
        }
        return packet;
    }

    private int readByte(InputStream inputStream, OperatingMode mode) throws InvalidPacketException, IOException {
        int timeout = 300;
        int b = this.readByteFrom(inputStream, timeout);
        if (b == -1) {
            throw new InvalidPacketException("Error parsing packet: Incomplete packet.");
        }
        if (mode == OperatingMode.API) {
            return b;
        }
        if (!SpecialByte.isSpecialByte(b)) {
            return b;
        }
        if (b == SpecialByte.ESCAPE_BYTE.getValue()) {
            b = this.readByteFrom(inputStream, timeout);
            if (b == -1) {
                throw new InvalidPacketException("Error parsing packet: Incomplete packet.");
            }
        } else {
            throw new InvalidPacketException("Special byte not escaped: 0x" + HexUtils.byteToHexString((byte)(b & 0xFF)) + ".");
        }
        return b ^= 0x20;
    }

    private byte[] readBytes(InputStream inputStream, OperatingMode mode, int numBytes) throws IOException, InvalidPacketException {
        byte[] data = new byte[numBytes];
        for (int i = 0; i < numBytes; ++i) {
            data[i] = (byte)this.readByte(inputStream, mode);
        }
        return data;
    }

    private int readByteFrom(InputStream inputStream, int timeout) throws IOException {
        long deadline = new Date().getTime() + (long)timeout;
        int b = inputStream.read();
        while (b == -1 && new Date().getTime() < deadline) {
            b = inputStream.read();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return b;
    }
}

