/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet;

import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeePacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XBeeAPIPacket
extends XBeePacket {
    public static final int NO_FRAME_ID = 9999;
    protected int frameID = 9999;
    private APIFrameType frameType = null;
    private int frameTypeValue;
    private Logger logger;

    protected XBeeAPIPacket(APIFrameType frameType) {
        if (frameType == null) {
            throw new NullPointerException("Frame type cannot be null.");
        }
        this.frameType = frameType;
        this.frameTypeValue = frameType.getValue();
        this.logger = LoggerFactory.getLogger(XBeeAPIPacket.class);
    }

    protected XBeeAPIPacket(int frameTypeValue) {
        if (frameTypeValue < 0 || frameTypeValue > 255) {
            throw new IllegalArgumentException("Frame type value must be between 0 and 255.");
        }
        this.frameTypeValue = frameTypeValue;
        this.frameType = APIFrameType.get(frameTypeValue);
        this.logger = LoggerFactory.getLogger(XBeeAPIPacket.class);
    }

    public APIFrameType getFrameType() {
        return this.frameType;
    }

    public int getFrameTypeValue() {
        return this.frameTypeValue;
    }

    @Override
    public byte[] getPacketData() {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        data.write(this.frameTypeValue);
        byte[] apiData = this.getAPIData();
        if (apiData == null) {
            apiData = new byte[]{};
        }
        if (apiData != null && apiData.length > 0) {
            try {
                data.write(apiData);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return data.toByteArray();
    }

    public byte[] getAPIData() {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        byte[] apiData = this.getAPIPacketSpecificData();
        if (apiData == null) {
            apiData = new byte[]{};
        }
        if (this.needsAPIFrameID()) {
            data.write(this.frameID);
        }
        if (apiData != null && apiData.length > 0) {
            try {
                data.write(apiData);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return data.toByteArray();
    }

    protected abstract byte[] getAPIPacketSpecificData();

    public abstract boolean needsAPIFrameID();

    public int getFrameID() {
        if (this.needsAPIFrameID()) {
            return this.frameID;
        }
        return 9999;
    }

    public void setFrameID(int frameID) {
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException("Frame ID must be between 0 and 255.");
        }
        if (this.needsAPIFrameID()) {
            this.frameID = frameID;
        }
    }

    public abstract boolean isBroadcast();

    public boolean checkFrameID(int id) {
        return this.needsAPIFrameID() && this.getFrameID() == id;
    }

    @Override
    protected LinkedHashMap<String, String> getPacketParameters() {
        LinkedHashMap<String, String> apiParams;
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (this.getFrameType() != null) {
            parameters.put("Frame type", HexUtils.prettyHexString(HexUtils.integerToHexString(this.frameTypeValue, 1)) + " (" + this.getFrameType().getName() + ")");
        } else {
            parameters.put("Frame type", HexUtils.prettyHexString(HexUtils.integerToHexString(this.frameTypeValue, 1)));
        }
        if (this.needsAPIFrameID()) {
            if (this.frameID == 9999) {
                parameters.put("Frame ID", "(NO FRAME ID)");
            } else {
                parameters.put("Frame ID", HexUtils.prettyHexString(HexUtils.integerToHexString(this.frameID, 1)) + " (" + this.frameID + ")");
            }
        }
        if ((apiParams = this.getAPIPacketParameters()) != null) {
            parameters.putAll(apiParams);
        }
        return parameters;
    }

    protected abstract LinkedHashMap<String, String> getAPIPacketParameters();
}

