/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.models.HardwareVersion;
import com.digi.xbee.api.models.HardwareVersionEnum;
import java.util.HashMap;

public enum XBeeProtocol {
    ZIGBEE(0, "ZigBee"),
    RAW_802_15_4(1, "802.15.4"),
    XBEE_WIFI(2, "Wi-Fi"),
    DIGI_MESH(3, "DigiMesh"),
    XCITE(4, "XCite"),
    XTEND(5, "XTend (Legacy)"),
    XTEND_DM(6, "XTend (DigiMesh)"),
    SMART_ENERGY(7, "Smart Energy"),
    DIGI_POINT(8, "Point-to-multipoint"),
    ZNET(9, "ZNet 2.5"),
    XC(10, "XSC"),
    XLR(11, "XLR"),
    XLR_DM(12, "XLR"),
    SX(13, "XBee SX"),
    XLR_MODULE(14, "XLR Module"),
    CELLULAR(15, "Cellular"),
    CELLULAR_NBIOT(16, "Cellular NB-IoT"),
    THREAD(17, "Thread"),
    UNKNOWN(99, "Unknown");

    private static final HashMap<Integer, XBeeProtocol> lookupTable;
    private final int id;
    private final String description;

    private XBeeProtocol(int id, String description) {
        this.id = id;
        this.description = description;
    }

    public int getID() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public static XBeeProtocol get(int id) {
        if (!lookupTable.containsKey(id)) {
            return UNKNOWN;
        }
        return lookupTable.get(id);
    }

    public static XBeeProtocol determineProtocol(HardwareVersion hardwareVersion, String firmwareVersion) {
        if (hardwareVersion == null || firmwareVersion == null || hardwareVersion.getValue() < 9 || HardwareVersionEnum.get(hardwareVersion.getValue()) == null) {
            return UNKNOWN;
        }
        switch (HardwareVersionEnum.get(hardwareVersion.getValue())) {
            case XC09_009: 
            case XC09_038: {
                return XCITE;
            }
            case XT09_XXX: 
            case XT09B_XXX: {
                if (firmwareVersion.length() == 4 && firmwareVersion.startsWith("8") || firmwareVersion.length() == 5 && firmwareVersion.charAt(1) == '8') {
                    return XTEND_DM;
                }
                return XTEND;
            }
            case XB24_AXX_XX: 
            case XBP24_AXX_XX: {
                if (firmwareVersion.length() == 4 && firmwareVersion.startsWith("8")) {
                    return DIGI_MESH;
                }
                return RAW_802_15_4;
            }
            case XB24_BXIX_XXX: 
            case XBP24_BXIX_XXX: {
                if (firmwareVersion.length() == 4 && firmwareVersion.startsWith("1") && firmwareVersion.endsWith("20") || firmwareVersion.length() == 4 && firmwareVersion.startsWith("2")) {
                    return ZIGBEE;
                }
                if (firmwareVersion.length() == 4 && firmwareVersion.startsWith("3")) {
                    return SMART_ENERGY;
                }
                return ZNET;
            }
            case XBP09_DXIX_XXX: {
                if (firmwareVersion.length() == 4 && firmwareVersion.startsWith("8") || firmwareVersion.length() == 4 && firmwareVersion.charAt(1) == '8' || firmwareVersion.length() == 5 && firmwareVersion.charAt(1) == '8') {
                    return DIGI_MESH;
                }
                return DIGI_POINT;
            }
            case XBP09_XCXX_XXX: {
                return XC;
            }
            case XBP08_DXXX_XXX: {
                return DIGI_POINT;
            }
            case XBP24B: {
                if (firmwareVersion.length() == 4 && firmwareVersion.startsWith("3")) {
                    return SMART_ENERGY;
                }
                return ZIGBEE;
            }
            case XB24_WF: 
            case WIFI_ATHEROS: 
            case SMT_WIFI_ATHEROS: {
                return XBEE_WIFI;
            }
            case XBP24C: 
            case XB24C: {
                if (firmwareVersion.length() == 4 && (firmwareVersion.startsWith("5") || firmwareVersion.startsWith("6"))) {
                    return SMART_ENERGY;
                }
                if (firmwareVersion.startsWith("2")) {
                    return RAW_802_15_4;
                }
                if (firmwareVersion.startsWith("9")) {
                    return DIGI_MESH;
                }
                return ZIGBEE;
            }
            case XSC_GEN3: 
            case SRD_868_GEN3: {
                if (firmwareVersion.length() == 4 && firmwareVersion.startsWith("8")) {
                    return DIGI_MESH;
                }
                if (firmwareVersion.length() == 4 && firmwareVersion.startsWith("1")) {
                    return DIGI_POINT;
                }
                return XC;
            }
            case XBEE_CELL_TH: {
                return UNKNOWN;
            }
            case XLR_MODULE: {
                if (firmwareVersion.startsWith("1")) {
                    return XLR;
                }
                return XLR_MODULE;
            }
            case XLR_BASEBOARD: {
                if (firmwareVersion.startsWith("1")) {
                    return XLR;
                }
                return XLR_MODULE;
            }
            case XB900HP_NZ: {
                return DIGI_POINT;
            }
            case XBP24C_TH_DIP: 
            case XB24C_TH_DIP: 
            case XBP24C_S2C_SMT: {
                if (firmwareVersion.length() == 4 && (firmwareVersion.startsWith("5") || firmwareVersion.startsWith("6"))) {
                    return SMART_ENERGY;
                }
                if (firmwareVersion.startsWith("2")) {
                    return RAW_802_15_4;
                }
                if (firmwareVersion.startsWith("9")) {
                    return DIGI_MESH;
                }
                return ZIGBEE;
            }
            case SX_PRO: 
            case SX: 
            case XTR: {
                if (firmwareVersion.startsWith("2")) {
                    return XTEND;
                }
                if (firmwareVersion.startsWith("8")) {
                    return XTEND_DM;
                }
                return SX;
            }
            case S2D_SMT_PRO: 
            case S2D_SMT_REG: 
            case S2D_TH_PRO: 
            case S2D_TH_REG: {
                if (firmwareVersion.startsWith("8")) {
                    return THREAD;
                }
                return ZIGBEE;
            }
            case CELLULAR: 
            case CELLULAR_CAT1_LTE_VERIZON: 
            case CELLULAR_3G: 
            case CELLULAR_LTE_VERIZON: 
            case CELLULAR_LTE_ATT: {
                return CELLULAR;
            }
            case CELLULAR_NBIOT_EUROPE: {
                return CELLULAR_NBIOT;
            }
        }
        return ZIGBEE;
    }

    public String toString() {
        return this.description;
    }

    static {
        lookupTable = new HashMap();
        for (XBeeProtocol xbeeProtocol : XBeeProtocol.values()) {
            lookupTable.put(xbeeProtocol.getID(), xbeeProtocol);
        }
    }
}

