/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.packet.XBeePacket;
import com.digi.xbee.api.packet.common.ExplicitRxIndicatorPacket;
import com.digi.xbee.api.packet.common.ReceivePacket;
import com.digi.xbee.api.packet.common.RemoteATCommandResponsePacket;
import com.digi.xbee.api.packet.ip.RXIPv4Packet;
import com.digi.xbee.api.packet.raw.RX16IOPacket;
import com.digi.xbee.api.packet.raw.RX16Packet;
import com.digi.xbee.api.packet.raw.RX64IOPacket;
import com.digi.xbee.api.packet.raw.RX64Packet;
import com.digi.xbee.api.packet.thread.RXIPv6Packet;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.util.LinkedList;

public class XBeePacketsQueue {
    public static final int DEFAULT_MAX_LENGTH = 50;
    private int maxLength = 50;
    private LinkedList<XBeePacket> packetsList;
    private Object lock = new Object();

    public XBeePacketsQueue() {
        this(50);
    }

    public XBeePacketsQueue(int maxLength) {
        if (maxLength < 1) {
            throw new IllegalArgumentException("Queue length must be greater than 0.");
        }
        this.maxLength = maxLength;
        this.packetsList = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacket(XBeePacket xbeePacket) {
        Object object = this.lock;
        synchronized (object) {
            if (this.packetsList.size() == this.maxLength) {
                this.packetsList.removeFirst();
            }
            this.packetsList.add(xbeePacket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearQueue() {
        Object object = this.lock;
        synchronized (object) {
            this.packetsList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XBeePacket getFirstPacket(int timeout) {
        if (timeout > 0) {
            XBeePacket xbeePacket = this.getFirstPacket(0);
            Long deadLine = System.currentTimeMillis() + (long)timeout;
            while (xbeePacket == null && deadLine > System.currentTimeMillis()) {
                this.sleep(100);
                xbeePacket = this.getFirstPacket(0);
            }
            return xbeePacket;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.packetsList.isEmpty()) {
                return this.packetsList.pop();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XBeePacket getFirstPacketFrom(RemoteXBeeDevice remoteXBeeDevice, int timeout) {
        if (timeout > 0) {
            XBeePacket xbeePacket = this.getFirstPacketFrom(remoteXBeeDevice, 0);
            Long deadLine = System.currentTimeMillis() + (long)timeout;
            while (xbeePacket == null && deadLine > System.currentTimeMillis()) {
                this.sleep(100);
                xbeePacket = this.getFirstPacketFrom(remoteXBeeDevice, 0);
            }
            return xbeePacket;
        }
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.packetsList.size(); ++i) {
                XBeePacket xbeePacket = this.packetsList.get(i);
                if (!this.addressesMatch(xbeePacket, remoteXBeeDevice)) continue;
                return this.packetsList.remove(i);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XBeePacket getFirstDataPacket(int timeout) {
        if (timeout > 0) {
            XBeePacket xbeePacket = this.getFirstDataPacket(0);
            Long deadLine = System.currentTimeMillis() + (long)timeout;
            while (xbeePacket == null && deadLine > System.currentTimeMillis()) {
                this.sleep(100);
                xbeePacket = this.getFirstDataPacket(0);
            }
            return xbeePacket;
        }
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.packetsList.size(); ++i) {
                XBeePacket xbeePacket = this.packetsList.get(i);
                if (!this.isDataPacket(xbeePacket)) continue;
                return this.packetsList.remove(i);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XBeePacket getFirstDataPacketFrom(RemoteXBeeDevice remoteXBeeDevice, int timeout) {
        if (timeout > 0) {
            XBeePacket xbeePacket = this.getFirstDataPacketFrom(remoteXBeeDevice, 0);
            Long deadLine = System.currentTimeMillis() + (long)timeout;
            while (xbeePacket == null && deadLine > System.currentTimeMillis()) {
                this.sleep(100);
                xbeePacket = this.getFirstDataPacketFrom(remoteXBeeDevice, 0);
            }
            return xbeePacket;
        }
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.packetsList.size(); ++i) {
                XBeePacket xbeePacket = this.packetsList.get(i);
                if (!this.isDataPacket(xbeePacket) || !this.addressesMatch(xbeePacket, remoteXBeeDevice)) continue;
                return this.packetsList.remove(i);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XBeePacket getFirstExplicitDataPacket(int timeout) {
        if (timeout > 0) {
            XBeePacket xbeePacket = this.getFirstExplicitDataPacket(0);
            Long deadLine = System.currentTimeMillis() + (long)timeout;
            while (xbeePacket == null && deadLine > System.currentTimeMillis()) {
                this.sleep(100);
                xbeePacket = this.getFirstExplicitDataPacket(0);
            }
            return xbeePacket;
        }
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.packetsList.size(); ++i) {
                XBeePacket xbeePacket = this.packetsList.get(i);
                if (!this.isExplicitDataPacket(xbeePacket)) continue;
                return this.packetsList.remove(i);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XBeePacket getFirstExplicitDataPacketFrom(RemoteXBeeDevice remoteXBeeDevice, int timeout) {
        if (timeout > 0) {
            XBeePacket xbeePacket = this.getFirstExplicitDataPacketFrom(remoteXBeeDevice, 0);
            Long deadLine = System.currentTimeMillis() + (long)timeout;
            while (xbeePacket == null && deadLine > System.currentTimeMillis()) {
                this.sleep(100);
                xbeePacket = this.getFirstExplicitDataPacketFrom(remoteXBeeDevice, 0);
            }
            return xbeePacket;
        }
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.packetsList.size(); ++i) {
                XBeePacket xbeePacket = this.packetsList.get(i);
                if (!this.isExplicitDataPacket(xbeePacket) || !this.addressesMatch(xbeePacket, remoteXBeeDevice)) continue;
                return this.packetsList.remove(i);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XBeePacket getFirstIPDataPacket(int timeout) {
        if (timeout > 0) {
            XBeePacket xbeePacket = this.getFirstIPDataPacket(0);
            Long deadLine = System.currentTimeMillis() + (long)timeout;
            while (xbeePacket == null && deadLine > System.currentTimeMillis()) {
                this.sleep(100);
                xbeePacket = this.getFirstIPDataPacket(0);
            }
            return xbeePacket;
        }
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.packetsList.size(); ++i) {
                XBeePacket xbeePacket = this.packetsList.get(i);
                if (!this.isIPDataPacket(xbeePacket)) continue;
                return this.packetsList.remove(i);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XBeePacket getFirstIPv6DataPacket(int timeout) {
        if (timeout > 0) {
            XBeePacket xbeePacket = this.getFirstIPv6DataPacket(0);
            Long deadLine = System.currentTimeMillis() + (long)timeout;
            while (xbeePacket == null && deadLine > System.currentTimeMillis()) {
                this.sleep(100);
                xbeePacket = this.getFirstIPv6DataPacket(0);
            }
            return xbeePacket;
        }
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.packetsList.size(); ++i) {
                XBeePacket xbeePacket = this.packetsList.get(i);
                if (!this.isIPv6DataPacket(xbeePacket)) continue;
                return this.packetsList.remove(i);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XBeePacket getFirstIPDataPacketFrom(Inet4Address ipAddress, int timeout) {
        if (timeout > 0) {
            XBeePacket xbeePacket = this.getFirstIPDataPacketFrom(ipAddress, 0);
            Long deadLine = System.currentTimeMillis() + (long)timeout;
            while (xbeePacket == null && deadLine > System.currentTimeMillis()) {
                this.sleep(100);
                xbeePacket = this.getFirstIPDataPacketFrom(ipAddress, 0);
            }
            return xbeePacket;
        }
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.packetsList.size(); ++i) {
                XBeePacket xbeePacket = this.packetsList.get(i);
                if (!this.isIPDataPacket(xbeePacket) || !this.ipAddressesMatch(xbeePacket, ipAddress)) continue;
                return this.packetsList.remove(i);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XBeePacket getFirstIPv6DataPacketFrom(Inet6Address ipv6Address, int timeout) {
        if (timeout > 0) {
            XBeePacket xbeePacket = this.getFirstIPv6DataPacketFrom(ipv6Address, 0);
            Long deadLine = System.currentTimeMillis() + (long)timeout;
            while (xbeePacket == null && deadLine > System.currentTimeMillis()) {
                this.sleep(100);
                xbeePacket = this.getFirstIPv6DataPacketFrom(ipv6Address, 0);
            }
            return xbeePacket;
        }
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.packetsList.size(); ++i) {
                XBeePacket xbeePacket = this.packetsList.get(i);
                if (!this.isIPv6DataPacket(xbeePacket) || !this.ipv6AddressesMatch(xbeePacket, ipv6Address)) continue;
                return this.packetsList.remove(i);
            }
        }
        return null;
    }

    private boolean addressesMatch(XBeePacket xbeePacket, RemoteXBeeDevice remoteXBeeDevice) {
        if (!(xbeePacket instanceof XBeeAPIPacket)) {
            return false;
        }
        APIFrameType packetType = ((XBeeAPIPacket)xbeePacket).getFrameType();
        switch (packetType) {
            case RECEIVE_PACKET: {
                if (remoteXBeeDevice.get64BitAddress() != null && ((ReceivePacket)xbeePacket).get64bitSourceAddress().equals(remoteXBeeDevice.get64BitAddress())) {
                    return true;
                }
                if (remoteXBeeDevice.get16BitAddress() == null || !((ReceivePacket)xbeePacket).get16bitSourceAddress().equals(remoteXBeeDevice.get16BitAddress())) break;
                return true;
            }
            case REMOTE_AT_COMMAND_RESPONSE: {
                if (remoteXBeeDevice.get64BitAddress() != null && ((RemoteATCommandResponsePacket)xbeePacket).get64bitSourceAddress().equals(remoteXBeeDevice.get64BitAddress())) {
                    return true;
                }
                if (remoteXBeeDevice.get16BitAddress() == null || !((RemoteATCommandResponsePacket)xbeePacket).get16bitSourceAddress().equals(remoteXBeeDevice.get16BitAddress())) break;
                return true;
            }
            case RX_16: {
                if (!((RX16Packet)xbeePacket).get16bitSourceAddress().equals(remoteXBeeDevice.get16BitAddress())) break;
                return true;
            }
            case RX_64: {
                if (!((RX64Packet)xbeePacket).get64bitSourceAddress().equals(remoteXBeeDevice.get64BitAddress())) break;
                return true;
            }
            case RX_IO_16: {
                if (!((RX16IOPacket)xbeePacket).get16bitSourceAddress().equals(remoteXBeeDevice.get16BitAddress())) break;
                return true;
            }
            case RX_IO_64: {
                if (!((RX64IOPacket)xbeePacket).get64bitSourceAddress().equals(remoteXBeeDevice.get64BitAddress())) break;
                return true;
            }
            case EXPLICIT_RX_INDICATOR: {
                if (!((ExplicitRxIndicatorPacket)xbeePacket).get64BitSourceAddress().equals(remoteXBeeDevice.get64BitAddress())) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    private boolean ipAddressesMatch(XBeePacket xbeePacket, Inet4Address ipAddress) {
        if (xbeePacket == null || ipAddress == null || !(xbeePacket instanceof XBeeAPIPacket)) {
            return false;
        }
        APIFrameType packetType = ((XBeeAPIPacket)xbeePacket).getFrameType();
        switch (packetType) {
            case RX_IPV4: {
                return ((RXIPv4Packet)xbeePacket).getSourceAddress().equals(ipAddress);
            }
            default: {
                return false;
            }
        }
    }

    private boolean ipv6AddressesMatch(XBeePacket xbeePacket, Inet6Address ipv6Address) {
        if (xbeePacket == null || ipv6Address == null || !(xbeePacket instanceof XBeeAPIPacket)) {
            return false;
        }
        APIFrameType packetType = ((XBeeAPIPacket)xbeePacket).getFrameType();
        switch (packetType) {
            case RX_IPV6: {
                return ((RXIPv6Packet)xbeePacket).getSourceAddress().equals(ipv6Address);
            }
            default: {
                return false;
            }
        }
    }

    private boolean isDataPacket(XBeePacket xbeePacket) {
        if (!(xbeePacket instanceof XBeeAPIPacket)) {
            return false;
        }
        APIFrameType packetType = ((XBeeAPIPacket)xbeePacket).getFrameType();
        switch (packetType) {
            case RECEIVE_PACKET: 
            case RX_16: 
            case RX_64: {
                return true;
            }
        }
        return false;
    }

    private boolean isExplicitDataPacket(XBeePacket xbeePacket) {
        if (!(xbeePacket instanceof XBeeAPIPacket)) {
            return false;
        }
        APIFrameType packetType = ((XBeeAPIPacket)xbeePacket).getFrameType();
        return packetType == APIFrameType.EXPLICIT_RX_INDICATOR;
    }

    private boolean isIPDataPacket(XBeePacket xbeePacket) {
        if (!(xbeePacket instanceof XBeeAPIPacket)) {
            return false;
        }
        APIFrameType packetType = ((XBeeAPIPacket)xbeePacket).getFrameType();
        return packetType == APIFrameType.RX_IPV4;
    }

    private boolean isIPv6DataPacket(XBeePacket xbeePacket) {
        if (!(xbeePacket instanceof XBeeAPIPacket)) {
            return false;
        }
        APIFrameType packetType = ((XBeeAPIPacket)xbeePacket).getFrameType();
        return packetType == APIFrameType.RX_IPV6;
    }

    private void sleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getMaxSize() {
        return this.maxLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.packetsList.size();
        }
    }
}

