/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.RemoteXBeeDevice;

public class XBeeMessage {
    private final RemoteXBeeDevice remoteXBeeDevice;
    private final byte[] data;
    private boolean isBroadcast;

    public XBeeMessage(RemoteXBeeDevice remoteXBeeDevice, byte[] data) {
        this(remoteXBeeDevice, data, false);
    }

    public XBeeMessage(RemoteXBeeDevice remoteXBeeDevice, byte[] data, boolean isBroadcast) {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null.");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        this.remoteXBeeDevice = remoteXBeeDevice;
        this.data = data;
        this.isBroadcast = isBroadcast;
    }

    public RemoteXBeeDevice getDevice() {
        return this.remoteXBeeDevice;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getDataString() {
        return new String(this.data);
    }

    public boolean isBroadcast() {
        return this.isBroadcast;
    }
}

