/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.utils.HexUtils;
import java.util.regex.Pattern;

public class XBeeIMEIAddress {
    private static final String ERROR_IMEI_NULL = "IMEI address cannot be null.";
    private static final String ERROR_IMEI_TOO_LONG = "IMEI address cannot be longer than 8 bytes.";
    private static final String ERROR_IMEI_INVALID = "Invalid IMEI address.";
    private static final int HASH_SEED = 23;
    private static final String IMEI_PATTERN = "^\\d{0,15}$";
    private byte[] address;

    public XBeeIMEIAddress(byte[] address) {
        if (address == null) {
            throw new NullPointerException(ERROR_IMEI_NULL);
        }
        if (address.length > 8) {
            throw new IllegalArgumentException(ERROR_IMEI_TOO_LONG);
        }
        this.generateByteAddress(address);
    }

    public XBeeIMEIAddress(String address) {
        if (address == null) {
            throw new NullPointerException(ERROR_IMEI_NULL);
        }
        if (!Pattern.matches(IMEI_PATTERN, address)) {
            throw new IllegalArgumentException(ERROR_IMEI_INVALID);
        }
        byte[] byteAddress = HexUtils.hexStringToByteArray(address);
        this.generateByteAddress(byteAddress);
    }

    private void generateByteAddress(byte[] byteAddress) {
        int i;
        this.address = new byte[8];
        int diff = 8 - byteAddress.length;
        for (i = 0; i < diff; ++i) {
            this.address[i] = 0;
        }
        for (i = diff; i < 8; ++i) {
            this.address[i] = byteAddress[i - diff];
        }
    }

    public String getValue() {
        return HexUtils.byteArrayToHexString(this.address).substring(1);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XBeeIMEIAddress)) {
            return false;
        }
        XBeeIMEIAddress addr = (XBeeIMEIAddress)obj;
        return addr.getValue().equals(this.getValue());
    }

    public int hashCode() {
        int hash = 23;
        for (byte b : this.getValue().getBytes()) {
            hash *= hash + b;
        }
        return hash;
    }

    public String toString() {
        return this.getValue();
    }
}

