/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.utils.HexUtils;
import java.util.Arrays;

public final class XBee16BitAddress {
    public static final XBee16BitAddress COORDINATOR_ADDRESS = new XBee16BitAddress("0000");
    public static final XBee16BitAddress BROADCAST_ADDRESS = new XBee16BitAddress("FFFF");
    public static final XBee16BitAddress UNKNOWN_ADDRESS = new XBee16BitAddress("FFFE");
    private static final String XBEE_16_BIT_ADDRESS_PATTERN = "(0[xX])?[0-9a-fA-F]{1,4}";
    private static final int HASH_SEED = 23;
    private final byte[] address;

    public XBee16BitAddress(int hsb, int lsb) {
        if (hsb > 255 || hsb < 0) {
            throw new IllegalArgumentException("HSB must be between 0 and 255.");
        }
        if (lsb > 255 || lsb < 0) {
            throw new IllegalArgumentException("LSB must be between 0 and 255.");
        }
        this.address = new byte[2];
        this.address[0] = (byte)hsb;
        this.address[1] = (byte)lsb;
    }

    public XBee16BitAddress(byte[] address) {
        int i;
        if (address == null) {
            throw new NullPointerException("Address cannot be null.");
        }
        if (address.length < 1) {
            throw new IllegalArgumentException("Address must contain at least 1 byte.");
        }
        if (address.length > 2) {
            throw new IllegalArgumentException("Address cannot contain more than 2 bytes.");
        }
        this.address = new byte[2];
        int diff = this.address.length - address.length;
        for (i = 0; i < diff; ++i) {
            this.address[i] = 0;
        }
        for (i = diff; i < this.address.length; ++i) {
            this.address[i] = address[i - diff];
        }
    }

    public XBee16BitAddress(String address) {
        int i;
        if (address == null) {
            throw new NullPointerException("Address cannot be null.");
        }
        if (address.length() < 1) {
            throw new IllegalArgumentException("Address must contain at least 1 character.");
        }
        if (!address.matches(XBEE_16_BIT_ADDRESS_PATTERN)) {
            throw new IllegalArgumentException("Address must follow this pattern: (0x)XXXX.");
        }
        byte[] byteAddress = HexUtils.hexStringToByteArray(address);
        this.address = new byte[2];
        int diff = this.address.length - byteAddress.length;
        for (i = 0; i < diff; ++i) {
            this.address[i] = 0;
        }
        for (i = diff; i < this.address.length; ++i) {
            this.address[i] = byteAddress[i - diff];
        }
    }

    public int getHsb() {
        return this.address[0];
    }

    public int getLsb() {
        return this.address[1];
    }

    public byte[] getValue() {
        return Arrays.copyOf(this.address, this.address.length);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XBee16BitAddress)) {
            return false;
        }
        XBee16BitAddress addr = (XBee16BitAddress)obj;
        return Arrays.equals(addr.getValue(), this.getValue());
    }

    public int hashCode() {
        int hash = 23;
        for (byte b : this.getValue()) {
            hash *= hash + b;
        }
        return hash;
    }

    public String toString() {
        return HexUtils.byteArrayToHexString(this.address);
    }
}

