/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import java.util.HashMap;

public enum WiFiEncryptionType {
    NONE(0, "No security"),
    WPA(1, "WPA (TKIP) security"),
    WPA2(2, "WPA2 (AES) security"),
    WEP(3, "WEP security");

    private int id;
    private String name;
    private static HashMap<Integer, WiFiEncryptionType> lookupTable;

    private WiFiEncryptionType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static WiFiEncryptionType get(int id) {
        return lookupTable.get(id);
    }

    public String toString() {
        return this.name;
    }

    static {
        lookupTable = new HashMap();
        for (WiFiEncryptionType encryptionType : WiFiEncryptionType.values()) {
            lookupTable.put(encryptionType.getID(), encryptionType);
        }
    }
}

