/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.utils.HexUtils;
import java.util.HashMap;

public enum ThreadAssociationIndicationStatus {
    ASSOCIATED(0, "Device Associated"),
    ALREADY_IN_NWK_BEFORE_RESET(1, "Device was part of a network before reset"),
    ATTEMPT_TO_FORM_JOIN_NWK(2, "Device is attempting to form/join network"),
    JOINED_WITHOUT_PARENT(3, "Device is joined but without a parent"),
    JOINED_ATTACHING(4, "Device is joined and currently attaching"),
    COMMISSION_FAILURE_INVALID_PARAM(244, "Commission failure because of invalid parameter"),
    COMMISSION_FAILURE_ALREADY_IN_NWK(245, "Commission failure because node is already part of a network. Issue a NR before attempting to join again"),
    JOIN_FAILURE_INVALID_PARAMS(246, "Join failure because of invalid parameters"),
    JOIN_FAILURE_ALREADY_IN_NWK(247, "Join failure because node is already part of a network. Issue a NR before attempting to join again"),
    FORM_NWK_FAILURE_SCAN_ALREADY_IN_PROGRESS(248, "Form network failure because a network scan was already in progress"),
    SECURITY_FAILURE(249, "Security failure"),
    COMMISSIONING_FAILURE(250, "Commissioning failure"),
    FAIL_TO_FIND_BEACON(251, "Device failed to find beacon with configured parameters"),
    FAIL_TO_FORM_NWK_SCAN_FAILURE(252, "Device failed to form network because of a scan failure"),
    FORM_JOIN_UNKNOWN_REASON_1(253, "Form/Join failure for unknown reason. Retry and if problem persists contact Digi support"),
    FORM_JOIN_UNKNOWN_REASON_2(254, "Form/Join failure for unknown reason. Retry and if problem persists contact Digi support"),
    DISASSOCIATED(255, "Disassociated");

    private final int value;
    private final String description;
    private static final HashMap<Integer, ThreadAssociationIndicationStatus> lookupTable;

    private ThreadAssociationIndicationStatus(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public static ThreadAssociationIndicationStatus get(int value) {
        return lookupTable.get(value);
    }

    public String toString() {
        return HexUtils.byteToHexString((byte)this.value) + ": " + this.description;
    }

    static {
        lookupTable = new HashMap();
        for (ThreadAssociationIndicationStatus associationIndicationStatus : ThreadAssociationIndicationStatus.values()) {
            lookupTable.put(associationIndicationStatus.getValue(), associationIndicationStatus);
        }
    }
}

