/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import java.util.HashMap;

public enum RestFulStatusEnum {
    SUCCESS(512, "Success"),
    CREATED(513, "Success: Created"),
    ACCEPTED(514, "Success: Accepted"),
    NON_AUTHORITATIVE(515, "Success: Non-Authoritative Information"),
    NO_CONTENT(516, "Success: No Content"),
    RESET_CONTENT(517, "Success: Reset Content"),
    CLIENT_ERROR_BAD_REQUEST(1024, "Client Error: Bad Request"),
    CLIENT_ERROR_UNAUTHORIZED(1025, "Client Error: Unauthorized"),
    CLIENT_ERROR_BAD_OPTION(1026, "Client Error: Bad Option"),
    CLIENT_ERROR_FORBIDDEN(1027, "Client Error: Forbidden"),
    CLIENT_ERROR_NOT_FOUND(1028, "Client Error: Not Found"),
    CLIENT_ERROR_NOT_ALLOWED(1029, "Client Error: Method Not Allowed"),
    CLIENT_ERROR_NOT_ACCEPTED(1030, "Client Error: Not Accepted"),
    CLIENT_ERROR_PRECONDITION_FAILED(1042, "Client Error: Precondition Failed"),
    CLIENT_ERROR_ENTITY_TOO_LARGE(1043, "Client Error: Request Entity Too Large"),
    CLIENT_ERROR_UNSUPPORTED_FORMAT(1045, "Client Error: Unsupported Content Format"),
    SERVER_ERROR(1280, "Server Error"),
    SERVER_ERROR_BAD_GATEWAY(1282, "Server Error: Bad Gateway"),
    SERVER_ERROR_SERVICE_UNAVAILABLE(1283, "Server Error: Service Unavailable"),
    SERVER_ERROR_GATEWAY_TIMEOUT(1284, "Server Error: Gateway Timeout"),
    SERVER_ERROR_PROXYING_NOT_SUPPORTED(1285, "Server Error: Proxying Not Supported");

    private final int id;
    private final String description;
    private static final HashMap<Integer, RestFulStatusEnum> lookupTable;

    private RestFulStatusEnum(int id, String description) {
        this.id = id;
        this.description = description;
    }

    public int getID() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public static RestFulStatusEnum get(int id) {
        return lookupTable.get(id);
    }

    public String toString() {
        return this.description + " [" + this.id + "]";
    }

    static {
        lookupTable = new HashMap();
        for (RestFulStatusEnum status : RestFulStatusEnum.values()) {
            lookupTable.put(status.getID(), status);
        }
    }
}

