/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import java.util.HashMap;

public enum ModemStatusEvent {
    STATUS_HARDWARE_RESET(0, "Device was reset"),
    STATUS_WATCHDOG_TIMER_RESET(1, "Watchdog timer was reset"),
    STATUS_JOINED_NETWORK(2, "Device joined to network"),
    STATUS_DISASSOCIATED(3, "Device disassociated"),
    STATUS_ERROR_SYNCHRONIZATION_LOST(4, "Configuration error/synchronization lost"),
    STATUS_COORDINATOR_REALIGNMENT(5, "Coordinator realignment"),
    STATUS_COORDINATOR_STARTED(6, "The coordinator started"),
    STATUS_NETWORK_SECURITY_KEY_UPDATED(7, "Network security key was updated"),
    STATUS_NETWORK_WOKE_UP(11, "Network Woke Up"),
    STATUS_NETWORK_WENT_TO_SLEEP(12, "Network Went To Sleep"),
    STATUS_VOLTAGE_SUPPLY_LIMIT_EXCEEDED(13, "Voltage supply limit exceeded"),
    STATUS_DEVICE_CLOUD_CONNECTED(14, "Device Cloud connected"),
    STATUS_DEVICE_CLOUD_DISCONNECTED(15, "Device Cloud disconnected"),
    STATUS_MODEM_CONFIG_CHANGED_WHILE_JOINING(17, " Modem configuration changed while joining"),
    STATUS_ERROR_STACK(128, "Stack error"),
    STATUS_ERROR_AP_NOT_CONNECTED(130, "Send/join command issued without connecting from AP"),
    STATUS_ERROR_AP_NOT_FOUND(131, "Access point not found"),
    STATUS_ERROR_PSK_NOT_CONFIGURED(132, "PSK not configured"),
    STATUS_ERROR_SSID_NOT_FOUND(135, "SSID not found"),
    STATUS_ERROR_FAILED_JOIN_SECURITY(136, "Failed to join with security enabled"),
    STATUS_ERROR_INVALID_CHANNEL(138, "Invalid channel"),
    STATUS_ERROR_FAILED_JOIN_AP(142, "Failed to join access point"),
    STATUS_UNKNOWN(255, "UNKNOWN");

    private final int id;
    private final String description;
    private static final HashMap<Integer, ModemStatusEvent> lookupTable;

    private ModemStatusEvent(int id, String description) {
        this.id = id;
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public static ModemStatusEvent get(int id) {
        ModemStatusEvent status = lookupTable.get(id);
        if (status != null) {
            return status;
        }
        return STATUS_UNKNOWN;
    }

    public String toString() {
        return String.format("0x%02X: %s", this.id, this.description);
    }

    static {
        lookupTable = new HashMap();
        for (ModemStatusEvent at : ModemStatusEvent.values()) {
            lookupTable.put(at.getId(), at);
        }
    }
}

