/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import java.util.HashMap;

public enum HardwareVersionEnum {
    X09_009(1, "X09-009"),
    X09_019(2, "X09-019"),
    XH9_009(3, "XH9-009"),
    XH9_019(4, "XH9-019"),
    X24_009(5, "X24-009"),
    X24_019(6, "X24-019"),
    X09_001(7, "X09-001"),
    XH9_001(8, "XH9-001"),
    X08_004(9, "X08-004"),
    XC09_009(10, "XC09-009"),
    XC09_038(11, "XC09-038"),
    X24_038(12, "X24-038"),
    X09_009_TX(13, "X09-009-TX"),
    X09_019_TX(14, "X09-019-TX"),
    XH9_009_TX(15, "XH9-009-TX"),
    XH9_019_TX(16, "XH9-019-TX"),
    X09_001_TX(17, "X09-001-TX"),
    XH9_001_TX(18, "XH9-001-TX"),
    XT09B_XXX(19, "XT09B-xxx (Attenuator version)"),
    XT09_XXX(20, "XT09-xxx"),
    XC08_009(21, "XC08-009"),
    XC08_038(22, "XC08-038"),
    XB24_AXX_XX(23, "XB24-Axx-xx"),
    XBP24_AXX_XX(24, "XBP24-Axx-xx"),
    XB24_BXIX_XXX(25, "XB24-BxIx-xxx and XB24-Z7xx-xxx"),
    XBP24_BXIX_XXX(26, "XBP24-BxIx-xxx and XBP24-Z7xx-xxx"),
    XBP09_DXIX_XXX(27, "XBP09-DxIx-xxx Digi Mesh"),
    XBP09_XCXX_XXX(28, "XBP09-XCxx-xxx: S3 XSC Compatibility"),
    XBP08_DXXX_XXX(29, "XBP08-Dxx-xxx 868MHz"),
    XBP24B(30, "XBP24B: Low cost ZB PRO and PLUS S2B"),
    XB24_WF(31, "XB24-WF: XBee 802.11 (Redpine module)"),
    AMBER_MBUS(32, "??????: M-Bus module made by Amber"),
    XBP24C(33, "XBP24C: XBee PRO SMT Ember 357 S2C PRO"),
    XB24C(34, "XB24C: XBee SMT Ember 357 S2C"),
    XSC_GEN3(35, "XSC_GEN3: XBP9 XSC 24 dBm"),
    SRD_868_GEN3(36, "SDR_868_GEN3: XB8 12 dBm"),
    ABANDONATED(37, "Abandonated"),
    SMT_900LP(38, "900LP (SMT): 900LP on 'S8 HW'"),
    WIFI_ATHEROS(39, "WiFi Atheros (TH-DIP) XB2S-WF"),
    SMT_WIFI_ATHEROS(40, "WiFi Atheros (SMT) XB2B-WF"),
    SMT_475LP(41, "475LP (SMT): Beta 475MHz"),
    XBEE_CELL_TH(42, "XBee-Cell (TH): XBee Cellular"),
    XLR_MODULE(43, "XLR Module"),
    XB900HP_NZ(44, "XB900HP (New Zealand): XB9 NZ HW/SW"),
    XBP24C_TH_DIP(45, "XBP24C (TH-DIP): XBee PRO DIP"),
    XB24C_TH_DIP(46, "XB24C (TH-DIP): XBee DIP"),
    XLR_BASEBOARD(47, "XLR Baseboard"),
    XBP24C_S2C_SMT(48, "XBee PRO SMT"),
    SX_PRO(49, "SX Pro"),
    S2D_SMT_PRO(50, "XBP24D: S2D SMT PRO"),
    S2D_SMT_REG(51, "XB24D: S2D SMT Reg"),
    S2D_TH_PRO(52, "XBP24D: S2D TH PRO"),
    S2D_TH_REG(53, "XB24D: S2D TH Reg"),
    SX(62, "SX"),
    XTR(63, "XTR"),
    CELLULAR(64, "CELLULAR"),
    CELLULAR_CAT1_LTE_VERIZON(64, "XBee Cellular Cat 1 LTE Verizon"),
    CELLULAR_3G(68, "XBee Cellular 3G"),
    CELLULAR_LTE_VERIZON(70, "XBee Cellular LTE-M Verizon"),
    CELLULAR_LTE_ATT(71, "XBee Cellular LTE-M AT&T"),
    CELLULAR_NBIOT_EUROPE(72, "XBee Cellular NBIoT Europe");

    private final int value;
    private final String description;
    private static final HashMap<Integer, HardwareVersionEnum> lookupTable;

    private HardwareVersionEnum(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public static HardwareVersionEnum get(int value) {
        return lookupTable.get(value);
    }

    public String toString() {
        return String.format("0x%02X: %s", this.value, this.description);
    }

    static {
        lookupTable = new HashMap();
        for (HardwareVersionEnum hv : HardwareVersionEnum.values()) {
            lookupTable.put(hv.getValue(), hv);
        }
    }
}

