/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.utils.HexUtils;
import java.util.HashMap;

public enum HTTPMethodEnum {
    EMPTY(0, "EMPTY"),
    GET(1, "GET"),
    POST(2, "POST"),
    PUT(3, "PUT"),
    DELETE(4, "DELETE");

    private int value;
    private String name;
    private static HashMap<Integer, HTTPMethodEnum> lookupTable;

    private HTTPMethodEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public static HTTPMethodEnum get(int value) {
        return lookupTable.get(value);
    }

    public String toString() {
        return HexUtils.byteToHexString((byte)this.value) + ": " + this.name;
    }

    static {
        lookupTable = new HashMap();
        for (HTTPMethodEnum function : HTTPMethodEnum.values()) {
            lookupTable.put(function.getValue(), function);
        }
    }
}

