/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import java.util.HashMap;

public enum DeviceCloudStatus {
    SUCCESS(0, "Success"),
    BAD_REQUEST(1, "Bad request"),
    RESPONSE_UNAVAILABLE(2, "Response unavailable"),
    DEVICE_CLOUD_ERROR(3, "Device Cloud error"),
    CANCELED(32, "Device Request canceled by user"),
    TIME_OUT(33, "Session timed out"),
    UNKNOWN_ERROR(64, "Unknown error");

    private int id;
    private String name;
    private static HashMap<Integer, DeviceCloudStatus> lookupTable;

    private DeviceCloudStatus(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static DeviceCloudStatus get(int id) {
        return lookupTable.get(id);
    }

    public String toString() {
        return this.name;
    }

    static {
        lookupTable = new HashMap();
        for (DeviceCloudStatus status : DeviceCloudStatus.values()) {
            lookupTable.put(status.getID(), status);
        }
    }
}

