/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.utils.HexUtils;
import java.util.HashMap;

public enum CellularAssociationIndicationStatus {
    SUCCESSFULLY_CONNECTED(0, "Connected to the Internet."),
    REGISTERING_CELLULAR_NETWORK(34, "Registering to cellular network"),
    CONNECTING_INTERNET(35, "Connecting to the Internet"),
    BYPASS_MODE(47, "Bypass mode active"),
    INITIALIZING(255, "Initializing");

    private final int value;
    private final String description;
    private static final HashMap<Integer, CellularAssociationIndicationStatus> lookupTable;

    private CellularAssociationIndicationStatus(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public static CellularAssociationIndicationStatus get(int value) {
        return lookupTable.get(value);
    }

    public String toString() {
        return HexUtils.byteToHexString((byte)this.value) + ": " + this.description;
    }

    static {
        lookupTable = new HashMap();
        for (CellularAssociationIndicationStatus associationIndicationStatus : CellularAssociationIndicationStatus.values()) {
            lookupTable.put(associationIndicationStatus.getValue(), associationIndicationStatus);
        }
    }
}

