/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import java.util.HashMap;

public enum ATCommandStatus {
    OK(0, "Status OK"),
    ERROR(1, "Status Error"),
    INVALID_COMMAND(2, "Invalid command"),
    INVALID_PARAMETER(3, "Invalid parameter"),
    TX_FAILURE(4, "TX failure"),
    UNKNOWN(255, "Unknown status");

    private int id;
    private final String description;
    private static final HashMap<Integer, ATCommandStatus> lookupTable;

    private ATCommandStatus(int id, String description) {
        this.id = id;
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public static ATCommandStatus get(int id) {
        ATCommandStatus status = lookupTable.get(id % 16);
        if (status == null) {
            status = UNKNOWN;
        }
        status.id = id;
        return status;
    }

    public String toString() {
        return this.description;
    }

    static {
        lookupTable = new HashMap();
        for (ATCommandStatus at : ATCommandStatus.values()) {
            lookupTable.put(at.getId(), at);
        }
    }
}

