/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.models;

import com.digi.xbee.api.models.ATCommand;
import com.digi.xbee.api.models.ATCommandStatus;

public class ATCommandResponse {
    private final ATCommand command;
    private final byte[] response;
    private final ATCommandStatus status;

    public ATCommandResponse(ATCommand command) {
        this(command, null, ATCommandStatus.OK);
    }

    public ATCommandResponse(ATCommand command, ATCommandStatus status) {
        this(command, null, status);
    }

    public ATCommandResponse(ATCommand command, byte[] response) {
        this(command, response, ATCommandStatus.OK);
    }

    public ATCommandResponse(ATCommand command, byte[] response, ATCommandStatus status) {
        if (command == null) {
            throw new NullPointerException("Command cannot be null.");
        }
        if (status == null) {
            throw new NullPointerException("Status cannot be null.");
        }
        this.command = command;
        this.response = response;
        this.status = status;
    }

    public ATCommand getCommand() {
        return this.command;
    }

    public byte[] getResponse() {
        return this.response;
    }

    public String getResponseString() {
        if (this.response == null) {
            return null;
        }
        return new String(this.response);
    }

    public ATCommandStatus getResponseStatus() {
        return this.status;
    }
}

