/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.io;

import com.digi.xbee.api.exceptions.OperationNotSupportedException;
import com.digi.xbee.api.io.IOLine;
import com.digi.xbee.api.io.IOValue;
import com.digi.xbee.api.utils.ByteUtils;
import java.util.Arrays;
import java.util.HashMap;

public class IOSample {
    private final byte[] ioSamplePayload;
    private int digitalHSBMask;
    private int digitalLSBMask;
    private int digitalMask;
    private int analogMask;
    private int digitalHSBValues;
    private int digitalLSBValues;
    private int digitalValues;
    private int powerSupplyVoltage;
    private final HashMap<IOLine, Integer> analogValuesMap = new HashMap();
    private final HashMap<IOLine, IOValue> digitalValuesMap = new HashMap();

    public IOSample(byte[] ioSamplePayload) {
        if (ioSamplePayload == null) {
            throw new NullPointerException("IO sample payload cannot be null.");
        }
        if (ioSamplePayload.length < 5) {
            throw new IllegalArgumentException("IO sample payload must be longer than 4.");
        }
        this.ioSamplePayload = ioSamplePayload;
        if (ioSamplePayload.length % 2 != 0) {
            this.parseRawIOSample();
        } else {
            this.parseIOSample();
        }
    }

    private void parseRawIOSample() {
        int dataIndex = 3;
        this.digitalHSBMask = this.ioSamplePayload[1] & 1;
        this.digitalLSBMask = this.ioSamplePayload[2] & 0xFF;
        this.digitalMask = (this.digitalHSBMask << 8) + this.digitalLSBMask;
        this.analogMask = (this.ioSamplePayload[1] << 8) + (this.ioSamplePayload[2] & 0xFF) & 0x7E00;
        if (this.digitalMask > 0) {
            this.digitalHSBValues = this.ioSamplePayload[3] & 0x7F;
            this.digitalLSBValues = this.ioSamplePayload[4] & 0xFF;
            this.digitalValues = (this.digitalHSBValues << 8) + this.digitalLSBValues;
            for (int i = 0; i < 16; ++i) {
                if (!ByteUtils.isBitEnabled(this.digitalMask, i)) continue;
                if (ByteUtils.isBitEnabled(this.digitalValues, i)) {
                    this.digitalValuesMap.put(IOLine.getDIO(i), IOValue.HIGH);
                    continue;
                }
                this.digitalValuesMap.put(IOLine.getDIO(i), IOValue.LOW);
            }
            dataIndex += 2;
        }
        int adcIndex = 9;
        while (this.ioSamplePayload.length - dataIndex > 1 && adcIndex < 16) {
            if (!ByteUtils.isBitEnabled(this.analogMask, adcIndex)) {
                ++adcIndex;
                continue;
            }
            this.analogValuesMap.put(IOLine.getDIO(adcIndex - 9), ((this.ioSamplePayload[dataIndex] & 0xFF) << 8) + (this.ioSamplePayload[dataIndex + 1] & 0xFF));
            dataIndex += 2;
            ++adcIndex;
        }
    }

    private void parseIOSample() {
        int dataIndex = 4;
        this.digitalHSBMask = this.ioSamplePayload[1] & 0x7F;
        this.digitalLSBMask = this.ioSamplePayload[2] & 0xFF;
        this.digitalMask = (this.digitalHSBMask << 8) + this.digitalLSBMask;
        this.analogMask = this.ioSamplePayload[3] & 0xBF;
        if (this.digitalMask > 0) {
            this.digitalHSBValues = this.ioSamplePayload[4] & 0x7F;
            this.digitalLSBValues = this.ioSamplePayload[5] & 0xFF;
            this.digitalValues = (this.digitalHSBValues << 8) + this.digitalLSBValues;
            for (int i = 0; i < 16; ++i) {
                if (!ByteUtils.isBitEnabled(this.digitalMask, i)) continue;
                if (ByteUtils.isBitEnabled(this.digitalValues, i)) {
                    this.digitalValuesMap.put(IOLine.getDIO(i), IOValue.HIGH);
                    continue;
                }
                this.digitalValuesMap.put(IOLine.getDIO(i), IOValue.LOW);
            }
            dataIndex += 2;
        }
        int adcIndex = 0;
        while (this.ioSamplePayload.length - dataIndex > 1 && adcIndex < 8) {
            if (!ByteUtils.isBitEnabled(this.analogMask, adcIndex)) {
                ++adcIndex;
                continue;
            }
            if (adcIndex == 7) {
                this.powerSupplyVoltage = ((this.ioSamplePayload[dataIndex] & 0xFF) << 8) + (this.ioSamplePayload[dataIndex + 1] & 0xFF);
            } else {
                this.analogValuesMap.put(IOLine.getDIO(adcIndex), ((this.ioSamplePayload[dataIndex] & 0xFF) << 8) + (this.ioSamplePayload[dataIndex + 1] & 0xFF));
            }
            dataIndex += 2;
            ++adcIndex;
        }
    }

    public int getDigitalHSBMask() {
        return this.digitalHSBMask;
    }

    public int getDigitalLSBMask() {
        return this.digitalLSBMask;
    }

    public int getDigitalMask() {
        return this.digitalMask;
    }

    public boolean hasDigitalValues() {
        return this.digitalValuesMap.size() > 0;
    }

    public boolean hasDigitalValue(IOLine ioLine) {
        return this.digitalValuesMap.containsKey((Object)ioLine);
    }

    public HashMap<IOLine, IOValue> getDigitalValues() {
        return (HashMap)this.digitalValuesMap.clone();
    }

    public IOValue getDigitalValue(IOLine ioLine) {
        if (!this.digitalValuesMap.containsKey((Object)ioLine)) {
            return null;
        }
        return this.digitalValuesMap.get((Object)ioLine);
    }

    public int getAnalogMask() {
        return this.analogMask;
    }

    public boolean hasAnalogValues() {
        return this.analogValuesMap.size() > 0;
    }

    public boolean hasAnalogValue(IOLine ioLine) {
        return this.analogValuesMap.containsKey((Object)ioLine);
    }

    public HashMap<IOLine, Integer> getAnalogValues() {
        return (HashMap)this.analogValuesMap.clone();
    }

    public Integer getAnalogValue(IOLine ioLine) {
        if (!this.analogValuesMap.containsKey((Object)ioLine)) {
            return null;
        }
        return this.analogValuesMap.get((Object)ioLine);
    }

    public boolean hasPowerSupplyValue() {
        return ByteUtils.isBitEnabled(this.analogMask, 7);
    }

    public int getPowerSupplyValue() throws OperationNotSupportedException {
        if (!ByteUtils.isBitEnabled(this.analogMask, 7)) {
            throw new OperationNotSupportedException();
        }
        return this.powerSupplyVoltage;
    }

    public String toString() {
        String s;
        StringBuilder sb = new StringBuilder("{");
        if (this.hasDigitalValues()) {
            for (IOLine line : this.digitalValuesMap.keySet()) {
                sb.append("[").append((Object)line).append(": ").append((Object)this.digitalValuesMap.get((Object)line)).append("], ");
            }
        }
        if (this.hasAnalogValues()) {
            for (IOLine line : this.analogValuesMap.keySet()) {
                sb.append("[").append((Object)line).append(": ").append(this.analogValuesMap.get((Object)line)).append("], ");
            }
        }
        if (this.hasPowerSupplyValue()) {
            try {
                sb.append("[").append("Power supply voltage: ").append(this.getPowerSupplyValue()).append("], ");
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                // empty catch block
            }
        }
        if ((s = sb.toString()).endsWith(", ")) {
            s = s.substring(0, s.length() - 2);
        }
        return s + "}";
    }

    public boolean equals(Object obj) {
        try {
            IOSample sample = (IOSample)obj;
            return Arrays.equals(this.ioSamplePayload, sample.ioSamplePayload);
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

