/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.io;

import com.digi.xbee.api.io.IOLine;
import java.util.HashMap;

public enum IOMode {
    DISABLED(0, "Disabled"),
    SPECIAL_FUNCTIONALITY(1, "Firmware special functionality"),
    PWM(2, "PWM output"),
    ADC(2, "Analog to Digital Converter"),
    DIGITAL_IN(3, "Digital input"),
    DIGITAL_OUT_LOW(4, "Digital output, Low"),
    DIGITAL_OUT_HIGH(5, "Digital output, High");

    private static final HashMap<Integer, IOMode> lookupTable;
    private final int id;
    private final String name;

    private IOMode(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static IOMode getIOMode(int modeID) {
        return IOMode.getIOMode(modeID, null);
    }

    public static IOMode getIOMode(int modeID, IOLine ioLine) {
        if (modeID == ADC.getID()) {
            if (ioLine != null && ioLine.hasPWMCapability()) {
                return PWM;
            }
            return ADC;
        }
        if (lookupTable.containsKey(modeID)) {
            return lookupTable.get(modeID);
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    static {
        lookupTable = new HashMap();
        for (IOMode ioMode : IOMode.values()) {
            lookupTable.put(ioMode.getID(), ioMode);
        }
    }
}

