/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.exceptions;

import com.digi.xbee.api.exceptions.CommunicationException;
import com.digi.xbee.api.models.XBeeTransmitStatus;

public class TransmitException
extends CommunicationException {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_MESSAGE = "There was a problem transmitting the XBee API packet.";
    private final XBeeTransmitStatus transmitStatus;

    public TransmitException(XBeeTransmitStatus transmitStatus) {
        super(DEFAULT_MESSAGE);
        this.transmitStatus = transmitStatus;
    }

    public TransmitException(String message, XBeeTransmitStatus transmitStatus) {
        super(message);
        this.transmitStatus = transmitStatus;
    }

    public TransmitException(String message, Throwable cause, XBeeTransmitStatus transmitStatus) {
        super(message, cause);
        this.transmitStatus = transmitStatus;
    }

    public XBeeTransmitStatus getTransmitStatus() {
        return this.transmitStatus;
    }

    public String getTransmitStatusMessage() {
        if (this.transmitStatus != null) {
            return this.transmitStatus.getDescription();
        }
        return null;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (message == null) {
            message = "";
        }
        if (this.transmitStatus != null) {
            if (message.length() > 0) {
                message = message + " > ";
            }
            message = message + this.transmitStatus.toString();
        }
        return message;
    }
}

