/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.exceptions;

import com.digi.xbee.api.exceptions.CommunicationException;
import com.digi.xbee.api.models.ATCommandStatus;

public class ATCommandException
extends CommunicationException {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_MESSAGE = "There was a problem sending the AT command packet.";
    private final ATCommandStatus atCommandStatus;

    public ATCommandException(ATCommandStatus atCommandStatus) {
        super(DEFAULT_MESSAGE);
        this.atCommandStatus = atCommandStatus;
    }

    public ATCommandException(String message, ATCommandStatus atCommandStatus) {
        super(message);
        this.atCommandStatus = atCommandStatus;
    }

    public ATCommandException(String message, Throwable cause, ATCommandStatus atCommandStatus) {
        super(message, cause);
        this.atCommandStatus = atCommandStatus;
    }

    public ATCommandStatus getCommandStatus() {
        return this.atCommandStatus;
    }

    public String getCommandStatusMessage() {
        if (this.atCommandStatus != null) {
            return this.atCommandStatus.getDescription();
        }
        return null;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (message == null) {
            message = "";
        }
        if (this.atCommandStatus != null) {
            if (message.length() > 0) {
                message = message + " > ";
            }
            message = message + this.atCommandStatus.getDescription();
        }
        return message;
    }
}

