/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.connection.serial;

import android.content.Context;
import com.digi.android.serial.ISerialPortEventListener;
import com.digi.android.serial.NoSuchPortException;
import com.digi.android.serial.PortInUseException;
import com.digi.android.serial.SerialPort;
import com.digi.android.serial.SerialPortEvent;
import com.digi.android.serial.SerialPortManager;
import com.digi.android.serial.UnsupportedCommOperationException;
import com.digi.xbee.api.connection.serial.AbstractSerialPort;
import com.digi.xbee.api.connection.serial.SerialPortParameters;
import com.digi.xbee.api.exceptions.ConnectionException;
import com.digi.xbee.api.exceptions.InterfaceInUseException;
import com.digi.xbee.api.exceptions.InvalidConfigurationException;
import com.digi.xbee.api.exceptions.InvalidInterfaceException;
import com.digi.xbee.api.exceptions.PermissionDeniedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialPortDigiAndroid
extends AbstractSerialPort
implements ISerialPortEventListener {
    private SerialPort serialPort;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Thread breakThread;
    private boolean breakEnabled = false;
    private Logger logger;
    private Context context;

    public SerialPortDigiAndroid(Context context, String port, int baudRate) {
        super(port, baudRate, 10);
        this.context = context;
        this.logger = LoggerFactory.getLogger(SerialPortDigiAndroid.class);
    }

    public SerialPortDigiAndroid(Context context, String port, int baudRate, int receiveTimeout) {
        super(port, baudRate, receiveTimeout);
        this.context = context;
        this.logger = LoggerFactory.getLogger(SerialPortDigiAndroid.class);
    }

    public SerialPortDigiAndroid(Context context, String port, SerialPortParameters parameters) {
        super(port, parameters, 10);
        this.context = context;
        this.logger = LoggerFactory.getLogger(SerialPortDigiAndroid.class);
    }

    public SerialPortDigiAndroid(Context context, String port, SerialPortParameters parameters, int receiveTimeout) {
        super(port, parameters, receiveTimeout);
        this.context = context;
        this.logger = LoggerFactory.getLogger(SerialPortDigiAndroid.class);
    }

    @Override
    public void open() throws InterfaceInUseException, InvalidInterfaceException, InvalidConfigurationException, PermissionDeniedException {
        try {
            SerialPortManager serialPortManager = new SerialPortManager(this.context);
            this.serialPort = serialPortManager.openSerialPort(this.port);
            this.connectionOpen = true;
            if (this.parameters == null) {
                this.parameters = new SerialPortParameters(this.baudRate, 8, 1, 0, 0);
            }
            this.serialPort.setPortParameters(this.baudRate, this.parameters.dataBits, this.parameters.stopBits, this.parameters.parity, this.parameters.flowControl);
            this.serialPort.enableReceiveTimeout(this.receiveTimeout);
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
            this.serialPort.notifyOnDataAvailable(true);
            this.serialPort.registerEventListener((ISerialPortEventListener)this);
        }
        catch (PortInUseException e) {
            throw new InterfaceInUseException("Port " + this.port + " is already in use by other application(s)", e);
        }
        catch (UnsupportedCommOperationException e) {
            throw new InvalidConfigurationException("Invalid serial port configuration: " + this.port + " " + e.getMessage(), e);
        }
        catch (TooManyListenersException e) {
            throw new InvalidConfigurationException("Invalid serial port configuration: " + this.port + " " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Error retrieving serial port streams: " + this.port, e);
        }
        catch (NoSuchPortException e) {
            throw new InvalidInterfaceException("No such port: " + this.port, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (this.serialPort != null) {
            try {
                this.serialPort.notifyOnDataAvailable(false);
                this.serialPort.unregisterEventListener();
                SerialPort serialPort = this.serialPort;
                synchronized (serialPort) {
                    this.serialPort.close();
                    this.serialPort = null;
                    this.connectionOpen = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case DATA_AVAILABLE: {
                try {
                    this.getInputStream().available();
                }
                catch (Exception e) {
                    this.close();
                    SerialPortDigiAndroid serialPortDigiAndroid = this;
                    synchronized (serialPortDigiAndroid) {
                        this.notify();
                        return;
                    }
                }
                try {
                    if (this.getInputStream().available() <= 0) return;
                    SerialPortDigiAndroid e = this;
                    synchronized (e) {
                        this.notify();
                        return;
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
                return;
            }
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public void setBreak(boolean enabled) {
        this.breakEnabled = enabled;
        if (this.breakEnabled) {
            if (this.breakThread == null) {
                this.breakThread = new Thread(){

                    @Override
                    public void run() {
                        while (SerialPortDigiAndroid.this.breakEnabled && SerialPortDigiAndroid.this.serialPort != null) {
                            SerialPortDigiAndroid.this.serialPort.sendBreak(100);
                        }
                    }
                };
                this.breakThread.start();
            }
        } else {
            if (this.breakThread != null) {
                this.breakThread.interrupt();
            }
            this.breakThread = null;
            this.serialPort.sendBreak(0);
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void setReadTimeout(int timeout) {
        this.serialPort.disableReceiveTimeout();
        try {
            this.serialPort.enableReceiveTimeout(timeout);
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getReadTimeout() {
        return this.serialPort.getReceiveTimeout();
    }

    @Override
    public void setDTR(boolean state) {
        this.serialPort.setDTR(state);
    }

    @Override
    public void setRTS(boolean state) {
        this.serialPort.setRTS(state);
    }

    @Override
    public void setPortParameters(int baudRate, int dataBits, int stopBits, int parity, int flowControl) throws InvalidConfigurationException, ConnectionException {
        this.parameters = new SerialPortParameters(baudRate, dataBits, stopBits, parity, flowControl);
        if (this.serialPort != null) {
            try {
                this.serialPort.setPortParameters(baudRate, dataBits, stopBits, parity, flowControl);
            }
            catch (UnsupportedCommOperationException e) {
                throw new InvalidConfigurationException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void sendBreak(int duration) {
        if (this.serialPort != null) {
            this.serialPort.sendBreak(duration);
        }
    }

    @Override
    public boolean isCTS() {
        return this.serialPort.isCTS();
    }

    @Override
    public boolean isDSR() {
        return this.serialPort.isDSR();
    }

    @Override
    public boolean isCD() {
        return this.serialPort.isCD();
    }
}

