/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.connection.serial;

import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.connection.serial.SerialPortParameters;
import com.digi.xbee.api.exceptions.ConnectionException;
import com.digi.xbee.api.exceptions.InvalidConfigurationException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerialPort
implements IConnectionInterface {
    public static final int DEFAULT_PORT_TIMEOUT = 10;
    public static final int DEFAULT_DATA_BITS = 8;
    public static final int DEFAULT_STOP_BITS = 1;
    public static final int DEFAULT_PARITY = 0;
    public static final int DEFAULT_FLOW_CONTROL = 0;
    protected static final int FLOW_CONTROL_HW = 3;
    protected static final String PORT_ALIAS = "Serial Port";
    protected String port;
    protected int baudRate;
    protected int receiveTimeout;
    protected SerialPortParameters parameters;
    protected boolean connectionOpen = false;
    private Logger logger;

    protected AbstractSerialPort(String port, SerialPortParameters parameters) {
        this(port, parameters, 10);
    }

    protected AbstractSerialPort(String port, int baudRate) {
        this(port, new SerialPortParameters(baudRate, 8, 1, 0, 0), 10);
    }

    protected AbstractSerialPort(String port, int baudRate, int receiveTimeout) {
        this(port, new SerialPortParameters(baudRate, 8, 1, 0, 0), receiveTimeout);
    }

    protected AbstractSerialPort(String port, SerialPortParameters parameters, int receiveTimeout) {
        if (port == null) {
            throw new NullPointerException("Serial port cannot be null.");
        }
        if (parameters == null) {
            throw new NullPointerException("SerialPortParameters cannot be null.");
        }
        if (port.length() == 0) {
            throw new IllegalArgumentException("Serial port cannot be an empty string.");
        }
        if (receiveTimeout < 0) {
            throw new IllegalArgumentException("Receive timeout cannot be less than 0.");
        }
        this.port = port;
        this.baudRate = parameters.baudrate;
        this.receiveTimeout = receiveTimeout;
        this.parameters = parameters;
        this.logger = LoggerFactory.getLogger(AbstractSerialPort.class);
    }

    @Override
    public boolean isOpen() {
        return this.connectionOpen;
    }

    public String getPort() {
        return this.port;
    }

    public abstract void setDTR(boolean var1);

    public abstract void setRTS(boolean var1);

    public abstract boolean isCTS();

    public abstract boolean isDSR();

    public abstract boolean isCD();

    public boolean isHardwareFlowControl() {
        return this.parameters.flowControl == 3;
    }

    public void setPortParameters(int baudRate, int dataBits, int stopBits, int parity, int flowControl) throws InvalidConfigurationException, ConnectionException {
        SerialPortParameters parameters = new SerialPortParameters(baudRate, dataBits, stopBits, parity, flowControl);
        this.setPortParameters(parameters);
    }

    public void setPortParameters(SerialPortParameters parameters) throws InvalidConfigurationException, ConnectionException {
        if (parameters == null) {
            throw new NullPointerException("Serial port parameters cannot be null.");
        }
        this.baudRate = parameters.baudrate;
        this.parameters = parameters;
        if (this.isOpen()) {
            this.close();
            this.open();
        }
    }

    public abstract void setBreak(boolean var1);

    public abstract void sendBreak(int var1);

    public abstract void setReadTimeout(int var1);

    public abstract int getReadTimeout();

    public void purge() {
        if (this.getInputStream() != null) {
            try {
                byte[] availableBytes = new byte[this.getInputStream().available()];
                if (this.getInputStream().available() > 0) {
                    this.getInputStream().read(availableBytes, 0, this.getInputStream().available());
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void flush() {
        if (this.getOutputStream() != null) {
            try {
                this.getOutputStream().flush();
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void writeData(byte[] data) throws IOException {
        if (data == null) {
            throw new NullPointerException("Data to be sent cannot be null.");
        }
        if (this.getOutputStream() != null) {
            if (this.isHardwareFlowControl()) {
                for (int tries = 0; tries < 3 && !this.isCTS(); ++tries) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.isCTS()) {
                    this.getOutputStream().write(data);
                    this.getOutputStream().flush();
                }
            } else {
                this.getOutputStream().write(data);
                this.getOutputStream().flush();
            }
        }
    }

    @Override
    public void writeData(byte[] data, int offset, int length) throws IOException {
        if (data == null) {
            throw new NullPointerException("Data to be sent cannot be null.");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be less than 0.");
        }
        if (length < 1) {
            throw new IllegalArgumentException("Length cannot be less than 1.");
        }
        if (offset >= data.length) {
            throw new IllegalArgumentException("Offset must be less than the data length.");
        }
        if (offset + length > data.length) {
            throw new IllegalArgumentException("Offset + length cannot be great than the data length.");
        }
        if (this.getOutputStream() != null) {
            if (this.isHardwareFlowControl()) {
                for (int tries = 0; tries < 3 && !this.isCTS(); ++tries) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.isCTS()) {
                    this.getOutputStream().write(data, offset, length);
                    this.getOutputStream().flush();
                }
            } else {
                this.getOutputStream().write(data, offset, length);
                this.getOutputStream().flush();
            }
        }
    }

    @Override
    public int readData(byte[] data) throws IOException {
        if (data == null) {
            throw new NullPointerException("Buffer cannot be null.");
        }
        int readBytes = 0;
        if (this.getInputStream() != null) {
            readBytes = this.getInputStream().read(data);
        }
        return readBytes;
    }

    @Override
    public int readData(byte[] data, int offset, int length) throws IOException {
        if (data == null) {
            throw new NullPointerException("Buffer cannot be null.");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be less than 0.");
        }
        if (length < 1) {
            throw new IllegalArgumentException("Length cannot be less than 1.");
        }
        if (offset >= data.length) {
            throw new IllegalArgumentException("Offset must be less than the buffer length.");
        }
        if (offset + length > data.length) {
            throw new IllegalArgumentException("Offset + length cannot be great than the buffer length.");
        }
        int readBytes = 0;
        if (this.getInputStream() != null) {
            readBytes = this.getInputStream().read(data, offset, length);
        }
        return readBytes;
    }

    public SerialPortParameters getPortParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        return new SerialPortParameters(this.baudRate, 8, 1, 0, 0);
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public String toString() {
        if (this.parameters != null) {
            String parity = "N";
            String flowControl = "N";
            if (this.parameters.parity == 1) {
                parity = "O";
            } else if (this.parameters.parity == 2) {
                parity = "E";
            } else if (this.parameters.parity == 3) {
                parity = "M";
            } else if (this.parameters.parity == 4) {
                parity = "S";
            }
            if (this.parameters.flowControl == 1 || this.parameters.flowControl == 2 || this.parameters.flowControl == 3) {
                flowControl = "H";
            } else if (this.parameters.flowControl == 4 || this.parameters.flowControl == 8 || this.parameters.flowControl == 12) {
                flowControl = "S";
            }
            return "[" + this.port + " - " + this.baudRate + "/" + this.parameters.dataBits + "/" + parity + "/" + this.parameters.stopBits + "/" + flowControl + "] ";
        }
        return "[" + this.port + " - " + this.baudRate + "/8/N/1/N] ";
    }
}

