/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.connection.android;

public class CircularByteBuffer {
    private byte[] buffer;
    private int readIndex;
    private int writeIndex;
    private boolean empty = true;

    public CircularByteBuffer(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Buffer size must be greater than 0.");
        }
        this.buffer = new byte[size];
        this.readIndex = 0;
        this.writeIndex = 0;
    }

    public synchronized int write(byte[] data, int offset, int numBytes) {
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        if (numBytes < 1) {
            throw new IllegalArgumentException("Number of bytes to write must be greater than 0.");
        }
        int availableBytes = data.length - offset;
        if (numBytes > availableBytes) {
            numBytes = availableBytes;
        }
        if (numBytes < this.buffer.length - this.getWriteIndex()) {
            System.arraycopy(data, offset, this.buffer, this.getWriteIndex(), numBytes);
            this.writeIndex = this.getWriteIndex() + numBytes;
        } else {
            System.arraycopy(data, offset, this.buffer, this.getWriteIndex(), this.buffer.length - this.getWriteIndex());
            System.arraycopy(data, offset + this.buffer.length - this.getWriteIndex(), this.buffer, 0, numBytes - (this.buffer.length - this.getWriteIndex()));
            this.writeIndex = numBytes - (this.buffer.length - this.getWriteIndex());
            if (this.getReadIndex() < this.getWriteIndex()) {
                this.readIndex = this.getWriteIndex();
            }
        }
        if (numBytes > this.getCapacity()) {
            numBytes = this.getCapacity();
        }
        this.empty = false;
        return numBytes;
    }

    public synchronized int read(byte[] data, int offset, int numBytes) {
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        if (numBytes < 1) {
            throw new IllegalArgumentException("Number of bytes to read must be greater than 0.");
        }
        if (this.empty) {
            return 0;
        }
        if (offset >= data.length) {
            return 0;
        }
        if (data.length - offset < numBytes) {
            return this.read(data, offset, data.length - offset);
        }
        if (this.availableToRead() < numBytes) {
            return this.read(data, offset, this.availableToRead());
        }
        if (numBytes < this.buffer.length - this.getReadIndex()) {
            System.arraycopy(this.buffer, this.getReadIndex(), data, offset, numBytes);
            this.readIndex = this.getReadIndex() + numBytes;
        } else {
            System.arraycopy(this.buffer, this.getReadIndex(), data, offset, this.buffer.length - this.getReadIndex());
            System.arraycopy(this.buffer, 0, data, offset + this.buffer.length - this.getReadIndex(), numBytes - (this.buffer.length - this.getReadIndex()));
            this.readIndex = numBytes - (this.buffer.length - this.getReadIndex());
        }
        if (this.readIndex == this.writeIndex) {
            this.empty = true;
        }
        return numBytes;
    }

    public synchronized int skip(int numBytes) {
        if (numBytes < 1) {
            throw new IllegalArgumentException("Number of bytes to skip must be greater than 0.");
        }
        if (this.empty) {
            return 0;
        }
        if (this.availableToRead() < numBytes) {
            return this.skip(this.availableToRead());
        }
        this.readIndex = numBytes < this.buffer.length - this.getReadIndex() ? this.getReadIndex() + numBytes : numBytes - (this.buffer.length - this.getReadIndex());
        if (this.readIndex == this.writeIndex) {
            this.empty = true;
        }
        return numBytes;
    }

    public int availableToRead() {
        if (this.empty) {
            return 0;
        }
        if (this.getReadIndex() < this.getWriteIndex()) {
            return this.getWriteIndex() - this.getReadIndex();
        }
        return this.buffer.length - this.getReadIndex() + this.getWriteIndex();
    }

    private int getReadIndex() {
        return this.readIndex;
    }

    private int getWriteIndex() {
        return this.writeIndex;
    }

    public int getCapacity() {
        return this.buffer.length;
    }

    public void clearBuffer() {
        this.empty = true;
        this.readIndex = 0;
        this.writeIndex = 0;
    }
}

