/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.connection.android;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.connection.android.AndroidUSBInputStream;
import com.digi.xbee.api.connection.android.AndroidUSBOutputStream;
import com.digi.xbee.api.connection.android.AndroidUSBPermissionListener;
import com.digi.xbee.api.exceptions.InterfaceInUseException;
import com.digi.xbee.api.exceptions.InvalidConfigurationException;
import com.digi.xbee.api.exceptions.InvalidInterfaceException;
import com.digi.xbee.api.exceptions.PermissionDeniedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidXBeeInterface
implements IConnectionInterface {
    private static final int VID = 1027;
    private static final int PID = 24577;
    private static final int BASE_CLOCK = 48000000;
    private static final String ACTION_USB_PERMISSION = "com.android.example.USB_PERMISSION";
    private UsbDevice usbDevice;
    private UsbDeviceConnection usbConnection;
    private UsbInterface usbInterface;
    private UsbEndpoint receiveEndPoint;
    private UsbEndpoint sendEndPoint;
    private PendingIntent mPermissionIntent;
    private UsbManager usbManager;
    private AndroidUSBInputStream inputStream;
    private AndroidUSBOutputStream outputStream;
    private boolean isConnected = false;
    private boolean permissionsReceived = false;
    private boolean permissionsGranted = false;
    private Context context;
    private int baudRate;
    private AndroidUSBPermissionListener permissionListener;
    private Logger logger;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        public void onReceive(Context arg0, Intent intent) {
            if (intent.getAction().equals(AndroidXBeeInterface.ACTION_USB_PERMISSION)) {
                AndroidXBeeInterface.this.usbDevice = (UsbDevice)intent.getParcelableExtra("device");
                AndroidXBeeInterface.this.context.unregisterReceiver(AndroidXBeeInterface.this.mUsbReceiver);
                if (AndroidXBeeInterface.this.permissionListener == null) {
                    if (intent.getBooleanExtra("permission", false)) {
                        AndroidXBeeInterface.this.permissionsGranted = true;
                    }
                    AndroidXBeeInterface.this.permissionsReceived = true;
                } else {
                    AndroidXBeeInterface.this.permissionListener.permissionReceived(intent.getBooleanExtra("permission", false));
                }
            }
        }
    };

    public AndroidXBeeInterface(Context context, int baudRate, UsbDevice usbDevice) {
        this(context, baudRate, usbDevice, null);
    }

    public AndroidXBeeInterface(Context context, int baudRate) {
        this(context, baudRate, null, null);
    }

    public AndroidXBeeInterface(Context context, int baudRate, AndroidUSBPermissionListener permissionListener) {
        this(context, baudRate, null, permissionListener);
    }

    public AndroidXBeeInterface(Context context, int baudRate, UsbDevice usbDevice, AndroidUSBPermissionListener permissionListener) {
        if (context == null) {
            throw new NullPointerException("Android contex cannot be null.");
        }
        if (baudRate < 1) {
            throw new IllegalArgumentException("Baud rate must be greater than 0.");
        }
        this.context = context;
        this.baudRate = baudRate;
        this.permissionListener = permissionListener;
        this.usbDevice = usbDevice;
        this.usbManager = (UsbManager)context.getSystemService("usb");
        this.logger = LoggerFactory.getLogger(AndroidXBeeInterface.class);
    }

    private int calculateBaudRate(int baud, int base) {
        int divisor = base / 16 / baud | ((base / 2 / baud & 4) != 0 ? 16384 : ((base / 2 / baud & 2) != 0 ? 32768 : ((base / 2 / baud & 1) != 0 ? 49152 : 0)));
        return divisor;
    }

    @Override
    public void open() throws InterfaceInUseException, InvalidInterfaceException, InvalidConfigurationException, PermissionDeniedException {
        this.permissionsReceived = false;
        this.permissionsGranted = false;
        if (this.usbDevice == null) {
            this.usbDevice = this.findDevice();
        }
        if (this.usbDevice == null) {
            throw new InvalidInterfaceException("XBee USB device not found");
        }
        if (!this.usbManager.hasPermission(this.usbDevice)) {
            this.mPermissionIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
            IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
            this.context.registerReceiver(this.mUsbReceiver, filter);
            this.usbManager.requestPermission(this.usbDevice, this.mPermissionIntent);
            if (this.permissionListener == null) {
                while (!this.permissionsReceived) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.permissionsGranted) {
                    throw new PermissionDeniedException("User didn't grant permissions to access XBee device.");
                }
            } else {
                throw new PermissionDeniedException("User didn't grant permissions to access XBee device.");
            }
        }
        this.startUSBConnection();
    }

    @Override
    public void close() {
        this.isConnected = false;
        if (this.inputStream != null) {
            this.inputStream.stopReadThread();
        }
        this.inputStream = null;
        this.outputStream = null;
        this.receiveEndPoint = null;
        this.sendEndPoint = null;
        if (this.usbConnection != null) {
            this.usbConnection.releaseInterface(this.usbInterface);
            this.usbConnection.close();
        }
        this.usbConnection = null;
        this.usbInterface = null;
        this.usbDevice = null;
    }

    @Override
    public boolean isOpen() {
        return this.isConnected;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void writeData(byte[] data) throws IOException {
        if (data == null) {
            throw new NullPointerException("Data to be sent cannot be null.");
        }
        if (this.getOutputStream() != null) {
            this.getOutputStream().write(data);
            this.getOutputStream().flush();
        }
    }

    @Override
    public void writeData(byte[] data, int offset, int length) throws IOException {
        if (data == null) {
            throw new NullPointerException("Data to be sent cannot be null.");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be less than 0.");
        }
        if (length < 1) {
            throw new IllegalArgumentException("Length cannot be less than 0.");
        }
        if (offset >= data.length) {
            throw new IllegalArgumentException("Offset must be less than the data length.");
        }
        if (offset + length > data.length) {
            throw new IllegalArgumentException("Offset + length cannot be great than the data length.");
        }
        if (this.getOutputStream() != null) {
            this.getOutputStream().write(data, offset, length);
            this.getOutputStream().flush();
        }
    }

    @Override
    public int readData(byte[] data) throws IOException {
        if (data == null) {
            throw new NullPointerException("Buffer cannot be null.");
        }
        int readBytes = 0;
        if (this.getInputStream() != null) {
            readBytes = this.getInputStream().read(data);
        }
        return readBytes;
    }

    @Override
    public int readData(byte[] data, int offset, int length) throws IOException {
        if (data == null) {
            throw new NullPointerException("Buffer cannot be null.");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be less than 0.");
        }
        if (length < 1) {
            throw new IllegalArgumentException("Length cannot be less than 0.");
        }
        if (offset >= data.length) {
            throw new IllegalArgumentException("Offset must be less than the buffer length.");
        }
        if (offset + length > data.length) {
            throw new IllegalArgumentException("Offset + length cannot be great than the buffer length.");
        }
        int readBytes = 0;
        if (this.getInputStream() != null) {
            readBytes = this.getInputStream().read(data, offset, length);
        }
        return readBytes;
    }

    private UsbDevice findDevice() {
        UsbDevice usbDevice = null;
        HashMap deviceList = this.usbManager.getDeviceList();
        for (UsbDevice device : deviceList.values()) {
            if (device.getProductId() != 24577 || device.getVendorId() != 1027) continue;
            usbDevice = device;
            this.logger.info("USB XBee Android device found: " + usbDevice.getDeviceName());
            break;
        }
        return usbDevice;
    }

    private void startUSBConnection() throws InterfaceInUseException {
        if (this.usbConnection == null) {
            this.usbConnection = this.usbManager.openDevice(this.usbDevice);
        }
        if (this.usbInterface == null) {
            this.usbInterface = this.usbDevice.getInterface(0);
        }
        if (!this.usbConnection.claimInterface(this.usbInterface, true)) {
            throw new InterfaceInUseException("Could not get control of USB interface, it may be in use by other applications.");
        }
        for (int i = 0; i < this.usbInterface.getEndpointCount(); ++i) {
            if (this.usbInterface.getEndpoint(i).getType() != 2) continue;
            if (this.usbInterface.getEndpoint(i).getDirection() == 128) {
                this.receiveEndPoint = this.usbInterface.getEndpoint(i);
                continue;
            }
            this.sendEndPoint = this.usbInterface.getEndpoint(i);
        }
        this.usbConnection.controlTransfer(64, 3, this.calculateBaudRate(this.baudRate, 48000000), 0, null, 0, 0);
        this.inputStream = new AndroidUSBInputStream(this, this.receiveEndPoint, this.usbConnection);
        this.outputStream = new AndroidUSBOutputStream(this.sendEndPoint, this.usbConnection);
        this.inputStream.startReadThread();
        this.isConnected = true;
    }
}

