/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.connection.android;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import com.digi.xbee.api.utils.HexUtils;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidUSBOutputStream
extends OutputStream {
    private static final int WRITE_TIMEOUT = 2000;
    private UsbDeviceConnection usbConnection;
    private UsbEndpoint sendEndPoint;
    private Logger logger;

    public AndroidUSBOutputStream(UsbEndpoint writeEndpoint, UsbDeviceConnection connection) {
        this.usbConnection = connection;
        this.sendEndPoint = writeEndpoint;
        this.logger = LoggerFactory.getLogger(AndroidUSBOutputStream.class);
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.write(new byte[]{(byte)oneByte});
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        final byte[] finalData = new byte[count + offset];
        System.arraycopy(buffer, offset, finalData, 0, count);
        Thread sendThread = new Thread(){

            @Override
            public void run() {
                AndroidUSBOutputStream.this.usbConnection.bulkTransfer(AndroidUSBOutputStream.this.sendEndPoint, finalData, finalData.length, 2000);
                AndroidUSBOutputStream.this.logger.debug("Message sent: " + HexUtils.byteArrayToHexString(finalData));
            }
        };
        sendThread.start();
    }
}

