/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.connection.android;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import com.digi.xbee.api.connection.android.AndroidXBeeInterface;
import com.digi.xbee.api.connection.android.CircularByteBuffer;
import com.digi.xbee.api.utils.HexUtils;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidUSBInputStream
extends InputStream {
    private static final int READ_BUFFER_SIZE = 1024;
    private static final int OFFSET = 2;
    private static final int READ_TIMEOUT = 100;
    private static final String ERROR_THREAD_NOT_INITIALIZED = "Read thread not initialized, call first 'startReadThread()'";
    private UsbDeviceConnection usbConnection;
    private UsbEndpoint receiveEndPoint;
    private boolean working = false;
    private Thread receiveThread;
    private CircularByteBuffer readBuffer;
    private AndroidXBeeInterface androidInterface;
    private Logger logger;

    public AndroidUSBInputStream(AndroidXBeeInterface androidInterface, UsbEndpoint readEndpoint, UsbDeviceConnection connection) {
        this.usbConnection = connection;
        this.receiveEndPoint = readEndpoint;
        this.androidInterface = androidInterface;
        this.logger = LoggerFactory.getLogger(AndroidUSBInputStream.class);
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        this.read(buffer);
        return buffer[0] & 0xFF;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.readBuffer == null) {
            throw new IOException(ERROR_THREAD_NOT_INITIALIZED);
        }
        long deadLine = System.currentTimeMillis() + 100L;
        int readBytes = 0;
        while (System.currentTimeMillis() < deadLine && readBytes <= 0) {
            readBytes = this.readBuffer.read(buffer, offset, length);
        }
        if (readBytes <= 0) {
            return -1;
        }
        byte[] readData = new byte[readBytes];
        System.arraycopy(buffer, offset, readData, 0, readBytes);
        this.logger.debug("Received a read request of " + length + " bytes, returning " + readData.length + ": " + HexUtils.byteArrayToHexString(readData));
        return readBytes;
    }

    @Override
    public int available() throws IOException {
        if (this.readBuffer == null) {
            throw new IOException(ERROR_THREAD_NOT_INITIALIZED);
        }
        return this.readBuffer.availableToRead();
    }

    @Override
    public long skip(long byteCount) throws IOException {
        if (this.readBuffer == null) {
            throw new IOException(ERROR_THREAD_NOT_INITIALIZED);
        }
        return this.readBuffer.skip((int)byteCount);
    }

    public void startReadThread() {
        if (!this.working) {
            this.readBuffer = new CircularByteBuffer(1024);
            this.receiveThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AndroidUSBInputStream.this.working = true;
                    while (AndroidUSBInputStream.this.working) {
                        byte[] buffer = new byte[1024];
                        int receivedBytes = AndroidUSBInputStream.this.usbConnection.bulkTransfer(AndroidUSBInputStream.this.receiveEndPoint, buffer, buffer.length, 100) - 2;
                        if (receivedBytes <= 0) continue;
                        byte[] data = new byte[receivedBytes];
                        System.arraycopy(buffer, 2, data, 0, receivedBytes);
                        AndroidUSBInputStream.this.logger.debug("Message received: " + HexUtils.byteArrayToHexString(data));
                        AndroidUSBInputStream.this.readBuffer.write(buffer, 2, receivedBytes);
                        AndroidXBeeInterface androidXBeeInterface = AndroidUSBInputStream.this.androidInterface;
                        synchronized (androidXBeeInterface) {
                            AndroidUSBInputStream.this.androidInterface.notify();
                        }
                    }
                }
            };
            this.receiveThread.start();
        }
    }

    public void stopReadThread() {
        this.working = false;
        if (this.receiveThread != null) {
            this.receiveThread.interrupt();
        }
    }
}

