/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import android.content.Context;
import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.XBee;
import com.digi.xbee.api.XBeeDevice;
import com.digi.xbee.api.XBeeNetwork;
import com.digi.xbee.api.ZigBeeNetwork;
import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.connection.android.AndroidUSBPermissionListener;
import com.digi.xbee.api.connection.serial.SerialPortParameters;
import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.OperationNotSupportedException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeDeviceException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.listeners.IExplicitDataReceiveListener;
import com.digi.xbee.api.models.APIOutputMode;
import com.digi.xbee.api.models.AssociationIndicationStatus;
import com.digi.xbee.api.models.ExplicitXBeeMessage;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeProtocol;
import com.digi.xbee.api.packet.common.ExplicitAddressingPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.net.Inet6Address;

public class ZigBeeDevice
extends XBeeDevice {
    private static final String OPERATION_EXCEPTION = "Operation not supported in ZigBee protocol.";

    public ZigBeeDevice(String port, int baudRate) {
        this(XBee.createConnectiontionInterface(port, baudRate));
    }

    public ZigBeeDevice(String port, int baudRate, int dataBits, int stopBits, int parity, int flowControl) {
        this(port, new SerialPortParameters(baudRate, dataBits, stopBits, parity, flowControl));
    }

    public ZigBeeDevice(String port, SerialPortParameters serialPortParameters) {
        this(XBee.createConnectiontionInterface(port, serialPortParameters));
    }

    public ZigBeeDevice(Context context, int baudRate) {
        super(XBee.createConnectiontionInterface(context, baudRate));
    }

    public ZigBeeDevice(Context context, int baudRate, AndroidUSBPermissionListener permissionListener) {
        super(XBee.createConnectiontionInterface(context, baudRate, permissionListener));
    }

    public ZigBeeDevice(Context context, String port, int baudRate) {
        super(XBee.createConnectiontionInterface(context, port, baudRate));
    }

    public ZigBeeDevice(Context context, String port, SerialPortParameters parameters) {
        super(XBee.createConnectiontionInterface(context, port, parameters));
    }

    public ZigBeeDevice(IConnectionInterface connectionInterface) {
        super(connectionInterface);
    }

    @Override
    public void open() throws XBeeException {
        super.open();
        if (this.xbeeProtocol != XBeeProtocol.ZIGBEE) {
            throw new XBeeDeviceException("XBee device is not a " + this.getXBeeProtocol().getDescription() + " device, it is a " + this.xbeeProtocol.getDescription() + " device.");
        }
    }

    @Override
    public XBeeNetwork getNetwork() {
        if (!this.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        if (this.network == null) {
            this.network = new ZigBeeNetwork(this);
        }
        return this.network;
    }

    @Override
    public XBeeProtocol getXBeeProtocol() {
        return XBeeProtocol.ZIGBEE;
    }

    @Override
    public void sendDataAsync(XBee64BitAddress address64Bit, XBee16BitAddress address16bit, byte[] data) throws XBeeException {
        super.sendDataAsync(address64Bit, address16bit, data);
    }

    @Override
    public void sendData(XBee64BitAddress address64Bit, XBee16BitAddress address16bit, byte[] data) throws TimeoutException, XBeeException {
        super.sendData(address64Bit, address16bit, data);
    }

    @Override
    public AssociationIndicationStatus getAssociationIndicationStatus() throws TimeoutException, XBeeException {
        return super.getAssociationIndicationStatus();
    }

    @Override
    public void forceDisassociate() throws TimeoutException, XBeeException {
        super.forceDisassociate();
    }

    @Override
    public ExplicitXBeeMessage readExplicitData() {
        return super.readExplicitData();
    }

    @Override
    public ExplicitXBeeMessage readExplicitData(int timeout) {
        return super.readExplicitData(timeout);
    }

    @Override
    public ExplicitXBeeMessage readExplicitDataFrom(RemoteXBeeDevice remoteXBeeDevice) {
        return super.readExplicitDataFrom(remoteXBeeDevice);
    }

    @Override
    public ExplicitXBeeMessage readExplicitDataFrom(RemoteXBeeDevice remoteXBeeDevice, int timeout) {
        return super.readExplicitDataFrom(remoteXBeeDevice, timeout);
    }

    @Override
    public void addExplicitDataListener(IExplicitDataReceiveListener listener) {
        super.addExplicitDataListener(listener);
    }

    @Override
    public void removeExplicitDataListener(IExplicitDataReceiveListener listener) {
        super.removeExplicitDataListener(listener);
    }

    @Override
    public APIOutputMode getAPIOutputMode() throws TimeoutException, XBeeException {
        return super.getAPIOutputMode();
    }

    @Override
    public void setAPIOutputMode(APIOutputMode apiOutputMode) throws TimeoutException, XBeeException {
        super.setAPIOutputMode(apiOutputMode);
    }

    @Override
    public void sendExplicitData(RemoteXBeeDevice remoteXBeeDevice, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws TimeoutException, XBeeException {
        super.sendExplicitData(remoteXBeeDevice, sourceEndpoint, destEndpoint, clusterID, profileID, data);
    }

    @Override
    public void sendExplicitData(XBee64BitAddress address64Bit, XBee16BitAddress address16bit, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws TimeoutException, XBeeException {
        super.sendExplicitData(address64Bit, address16bit, sourceEndpoint, destEndpoint, clusterID, profileID, data);
    }

    @Override
    public void sendBroadcastExplicitData(int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws TimeoutException, XBeeException {
        super.sendBroadcastExplicitData(sourceEndpoint, destEndpoint, clusterID, profileID, data);
    }

    @Override
    public void sendExplicitDataAsync(RemoteXBeeDevice xbeeDevice, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws XBeeException {
        super.sendExplicitDataAsync(xbeeDevice, sourceEndpoint, destEndpoint, clusterID, profileID, data);
    }

    @Override
    public void sendExplicitDataAsync(XBee64BitAddress address64Bit, XBee16BitAddress address16Bit, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws XBeeException {
        super.sendExplicitDataAsync(address64Bit, address16Bit, sourceEndpoint, destEndpoint, clusterID, profileID, data);
    }

    public void sendMulticastData(XBee16BitAddress groupID, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws XBeeException {
        if (groupID == null) {
            throw new NullPointerException("Destination group ID cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        if (sourceEndpoint < 0 || sourceEndpoint > 255) {
            throw new IllegalArgumentException("Source endpoint must be between 0 and 0xFF.");
        }
        if (destEndpoint < 0 || destEndpoint > 255) {
            throw new IllegalArgumentException("Destination endpoint must be between 0 and 0xFF.");
        }
        if (clusterID < 0 || clusterID > 65535) {
            throw new IllegalArgumentException("Cluster ID must be between 0 and 0xFFFF.");
        }
        if (profileID < 0 || profileID > 65535) {
            throw new IllegalArgumentException("Profile ID must be between 0 and 0xFFFF.");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send multicast data to a remote device from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending multicast data to {} [{} - {} - {} - {}] >> {}.", new Object[]{groupID, HexUtils.integerToHexString(sourceEndpoint, 1), HexUtils.integerToHexString(destEndpoint, 1), HexUtils.integerToHexString(clusterID, 2), HexUtils.integerToHexString(profileID, 2), HexUtils.prettyHexString(data)});
        ExplicitAddressingPacket xbeePacket = new ExplicitAddressingPacket(this.getNextFrameID(), XBee64BitAddress.UNKNOWN_ADDRESS, groupID, sourceEndpoint, destEndpoint, clusterID, profileID, 0, 8, data);
        this.sendAndCheckXBeePacket(xbeePacket, false);
    }

    public void sendMulticastDataAsync(XBee16BitAddress groupID, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws XBeeException {
        if (groupID == null) {
            throw new NullPointerException("Destination group ID cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        if (sourceEndpoint < 0 || sourceEndpoint > 255) {
            throw new IllegalArgumentException("Source endpoint must be between 0 and 0xFF.");
        }
        if (destEndpoint < 0 || destEndpoint > 255) {
            throw new IllegalArgumentException("Destination endpoint must be between 0 and 0xFF.");
        }
        if (clusterID < 0 || clusterID > 65535) {
            throw new IllegalArgumentException("Cluster ID must be between 0 and 0xFFFF.");
        }
        if (profileID < 0 || profileID > 65535) {
            throw new IllegalArgumentException("Profile ID must be between 0 and 0xFFFF.");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send multicast data to a remote device from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending multicast data asynchronously to {} [{} - {} - {} - {}] >> {}.", new Object[]{groupID, HexUtils.integerToHexString(sourceEndpoint, 1), HexUtils.integerToHexString(destEndpoint, 1), HexUtils.integerToHexString(clusterID, 2), HexUtils.integerToHexString(profileID, 2), HexUtils.prettyHexString(data)});
        ExplicitAddressingPacket xbeePacket = new ExplicitAddressingPacket(this.getNextFrameID(), XBee64BitAddress.UNKNOWN_ADDRESS, groupID, sourceEndpoint, destEndpoint, clusterID, profileID, 0, 8, data);
        this.sendAndCheckXBeePacket(xbeePacket, true);
    }

    @Override
    public Inet6Address getIPv6Address() {
        return null;
    }

    @Override
    public Inet6Address getIPv6DestinationAddress() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void setIPv6DestinationAddress(Inet6Address ipv6Address) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }
}

