/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import com.digi.xbee.api.NodeDiscovery;
import com.digi.xbee.api.RemoteRaw802Device;
import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.RemoteZigBeeDevice;
import com.digi.xbee.api.XBeeDevice;
import com.digi.xbee.api.exceptions.OperationNotSupportedException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.listeners.IDiscoveryListener;
import com.digi.xbee.api.models.DiscoveryOptions;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeProtocol;
import com.digi.xbee.api.utils.ByteUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeeNetwork {
    private XBeeDevice localDevice;
    private Map<XBee64BitAddress, RemoteXBeeDevice> remotesBy64BitAddr;
    private Map<XBee16BitAddress, RemoteXBeeDevice> remotesBy16BitAddr;
    private List<IDiscoveryListener> discoveryListeners = new ArrayList<IDiscoveryListener>();
    private NodeDiscovery nodeDiscovery;
    protected Logger logger;

    XBeeNetwork(XBeeDevice device) {
        if (device == null) {
            throw new NullPointerException("Local XBee device cannot be null.");
        }
        this.localDevice = device;
        this.remotesBy64BitAddr = new ConcurrentHashMap<XBee64BitAddress, RemoteXBeeDevice>();
        this.remotesBy16BitAddr = new ConcurrentHashMap<XBee16BitAddress, RemoteXBeeDevice>();
        this.nodeDiscovery = new NodeDiscovery(this.localDevice);
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public RemoteXBeeDevice discoverDevice(String id) throws XBeeException {
        if (id == null) {
            throw new NullPointerException("Device identifier cannot be null.");
        }
        if (id.length() == 0) {
            throw new IllegalArgumentException("Device identifier cannot be an empty string.");
        }
        this.logger.debug("{}Discovering '{}' device.", (Object)this.localDevice.toString(), (Object)id);
        return this.nodeDiscovery.discoverDevice(id);
    }

    public List<RemoteXBeeDevice> discoverDevices(List<String> ids) throws XBeeException {
        if (ids == null) {
            throw new NullPointerException("List of device identifiers cannot be null.");
        }
        if (ids.size() == 0) {
            throw new IllegalArgumentException("List of device identifiers cannot be empty.");
        }
        this.logger.debug("{}Discovering all '{}' devices.", (Object)this.localDevice.toString(), (Object)ids.toString());
        return this.nodeDiscovery.discoverDevices(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoveryListener(IDiscoveryListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        List<IDiscoveryListener> list = this.discoveryListeners;
        synchronized (list) {
            if (!this.discoveryListeners.contains(listener)) {
                this.discoveryListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDiscoveryListener(IDiscoveryListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null.");
        }
        List<IDiscoveryListener> list = this.discoveryListeners;
        synchronized (list) {
            if (this.discoveryListeners.contains(listener)) {
                this.discoveryListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDiscoveryProcess() {
        if (this.isDiscoveryRunning()) {
            throw new IllegalStateException("The discovery process is already running.");
        }
        List<IDiscoveryListener> list = this.discoveryListeners;
        synchronized (list) {
            this.nodeDiscovery.startDiscoveryProcess(this.discoveryListeners);
        }
    }

    public void stopDiscoveryProcess() {
        this.nodeDiscovery.stopDiscoveryProcess();
    }

    public boolean isDiscoveryRunning() {
        return this.nodeDiscovery.isRunning();
    }

    public void setDiscoveryTimeout(long timeout) throws TimeoutException, XBeeException {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be bigger than 0.");
        }
        this.localDevice.setParameter("NT", ByteUtils.longToByteArray(timeout / 100L));
    }

    public void setDiscoveryOptions(Set<DiscoveryOptions> options) throws TimeoutException, XBeeException {
        if (options == null) {
            throw new NullPointerException("Options cannot be null.");
        }
        int value = DiscoveryOptions.calculateDiscoveryValue(this.localDevice.getXBeeProtocol(), options);
        this.localDevice.setParameter("NO", ByteUtils.intToByteArray(value));
    }

    public List<RemoteXBeeDevice> getDevices() {
        ArrayList<RemoteXBeeDevice> nodes = new ArrayList<RemoteXBeeDevice>();
        nodes.addAll(this.remotesBy64BitAddr.values());
        nodes.addAll(this.remotesBy16BitAddr.values());
        return nodes;
    }

    public List<RemoteXBeeDevice> getDevices(String id) {
        if (id == null) {
            throw new NullPointerException("Device identifier cannot be null.");
        }
        if (id.length() == 0) {
            throw new IllegalArgumentException("Device identifier cannot be an empty string.");
        }
        ArrayList<RemoteXBeeDevice> devices = new ArrayList<RemoteXBeeDevice>();
        for (RemoteXBeeDevice remote : this.remotesBy64BitAddr.values()) {
            if (!id.equals(remote.getNodeID())) continue;
            devices.add(remote);
        }
        for (RemoteXBeeDevice remote : this.remotesBy16BitAddr.values()) {
            if (!id.equals(remote.getNodeID())) continue;
            devices.add(remote);
        }
        return devices;
    }

    public RemoteXBeeDevice getDevice(String id) {
        if (id == null) {
            throw new NullPointerException("Device identifier cannot be null.");
        }
        if (id.length() == 0) {
            throw new IllegalArgumentException("Device identifier cannot be an empty string.");
        }
        for (RemoteXBeeDevice remote : this.remotesBy64BitAddr.values()) {
            if (!id.equals(remote.getNodeID())) continue;
            return remote;
        }
        for (RemoteXBeeDevice remote : this.remotesBy16BitAddr.values()) {
            if (!id.equals(remote.getNodeID())) continue;
            return remote;
        }
        return null;
    }

    public RemoteXBeeDevice getDevice(XBee64BitAddress address) {
        if (address == null) {
            throw new NullPointerException("64-bit address cannot be null.");
        }
        if (address.equals(XBee64BitAddress.UNKNOWN_ADDRESS)) {
            throw new IllegalArgumentException("64-bit address cannot be unknown.");
        }
        this.logger.debug("{}Getting device '{}' from network.", (Object)this.localDevice.toString(), (Object)address);
        return this.remotesBy64BitAddr.get(address);
    }

    public RemoteXBeeDevice getDevice(XBee16BitAddress address) throws OperationNotSupportedException {
        if (this.localDevice.getXBeeProtocol() == XBeeProtocol.DIGI_MESH) {
            throw new OperationNotSupportedException("DigiMesh protocol does not support 16-bit addressing.");
        }
        if (this.localDevice.getXBeeProtocol() == XBeeProtocol.DIGI_POINT) {
            throw new OperationNotSupportedException("Point-to-Multipoint protocol does not support 16-bit addressing.");
        }
        if (address == null) {
            throw new NullPointerException("16-bit address cannot be null.");
        }
        if (address.equals(XBee16BitAddress.UNKNOWN_ADDRESS)) {
            throw new IllegalArgumentException("16-bit address cannot be unknown.");
        }
        this.logger.debug("{}Getting device '{}' from network.", (Object)this.localDevice.toString(), (Object)address);
        RemoteXBeeDevice devInNetwork = null;
        Collection<RemoteXBeeDevice> devices = this.remotesBy64BitAddr.values();
        for (RemoteXBeeDevice d : devices) {
            XBee16BitAddress a = this.get16BitAddress(d);
            if (a == null || !a.equals(address)) continue;
            devInNetwork = d;
            break;
        }
        if (devInNetwork == null) {
            devInNetwork = this.remotesBy16BitAddr.get(address);
        }
        return devInNetwork;
    }

    public RemoteXBeeDevice addRemoteDevice(RemoteXBeeDevice remoteDevice) {
        if (remoteDevice == null) {
            throw new NullPointerException("Remote device cannot be null.");
        }
        this.logger.debug("{}Adding device '{}' to network.", (Object)this.localDevice.toString(), (Object)remoteDevice.toString());
        RemoteXBeeDevice devInNetwork = null;
        XBee64BitAddress addr64 = remoteDevice.get64BitAddress();
        XBee16BitAddress addr16 = this.get16BitAddress(remoteDevice);
        if (addr64 != null && !addr64.equals(XBee64BitAddress.UNKNOWN_ADDRESS)) {
            devInNetwork = this.remotesBy64BitAddr.get(addr64);
            if (devInNetwork != null) {
                this.logger.debug("{}Existing device '{}' in network.", (Object)this.localDevice.toString(), (Object)devInNetwork.toString());
                devInNetwork.updateDeviceDataFrom(remoteDevice);
                return devInNetwork;
            }
            if (addr16 != null && !addr16.equals(XBee16BitAddress.UNKNOWN_ADDRESS)) {
                devInNetwork = this.remotesBy16BitAddr.get(addr16);
                if (devInNetwork != null) {
                    this.logger.debug("{}Existing device '{}' in network.", (Object)this.localDevice.toString(), (Object)devInNetwork.toString());
                    devInNetwork = this.remotesBy16BitAddr.remove(addr16);
                    devInNetwork.updateDeviceDataFrom(remoteDevice);
                    this.remotesBy64BitAddr.put(addr64, devInNetwork);
                    return devInNetwork;
                }
                this.remotesBy64BitAddr.put(addr64, remoteDevice);
                return remoteDevice;
            }
            this.remotesBy64BitAddr.put(addr64, remoteDevice);
            return remoteDevice;
        }
        if (addr16 != null && !addr16.equals(XBee16BitAddress.UNKNOWN_ADDRESS)) {
            Collection<RemoteXBeeDevice> devices = this.remotesBy64BitAddr.values();
            for (RemoteXBeeDevice d : devices) {
                XBee16BitAddress a = this.get16BitAddress(d);
                if (a == null || !a.equals(addr16)) continue;
                devInNetwork = d;
                break;
            }
            if (devInNetwork != null) {
                this.logger.debug("{}Existing device '{}' in network.", (Object)this.localDevice.toString(), (Object)devInNetwork.toString());
                devInNetwork.updateDeviceDataFrom(remoteDevice);
                return devInNetwork;
            }
            devInNetwork = this.remotesBy16BitAddr.get(addr16);
            if (devInNetwork != null) {
                this.logger.debug("{}Existing device '{}' in network.", (Object)this.localDevice.toString(), (Object)devInNetwork.toString());
                devInNetwork.updateDeviceDataFrom(remoteDevice);
                return devInNetwork;
            }
            this.remotesBy16BitAddr.put(addr16, remoteDevice);
            return remoteDevice;
        }
        this.logger.error("{}Remote device '{}' cannot be added: 64-bit and 16-bit addresses must be specified.", (Object)this.localDevice.toString(), (Object)remoteDevice.toString());
        return null;
    }

    public List<RemoteXBeeDevice> addRemoteDevices(List<RemoteXBeeDevice> list) {
        if (list == null) {
            throw new NullPointerException("The list of remote devices cannot be null.");
        }
        ArrayList<RemoteXBeeDevice> addedList = new ArrayList<RemoteXBeeDevice>(list.size());
        if (list.size() == 0) {
            return addedList;
        }
        this.logger.debug("{}Adding '{}' devices to network.", (Object)this.localDevice.toString(), (Object)list.size());
        for (int i = 0; i < list.size(); ++i) {
            RemoteXBeeDevice d;
            RemoteXBeeDevice toAdd = list.get(i);
            if (toAdd == null || (d = this.addRemoteDevice(toAdd)) == null) continue;
            addedList.add(d);
        }
        return addedList;
    }

    public void removeRemoteDevice(RemoteXBeeDevice remoteDevice) {
        if (remoteDevice == null) {
            throw new NullPointerException("Remote device cannot be null.");
        }
        RemoteXBeeDevice devInNetwork = null;
        XBee64BitAddress addr64 = remoteDevice.get64BitAddress();
        if (addr64 != null && !addr64.equals(XBee64BitAddress.UNKNOWN_ADDRESS) && (devInNetwork = this.remotesBy64BitAddr.get(addr64)) != null) {
            this.remotesBy64BitAddr.remove(addr64);
            return;
        }
        XBee16BitAddress addr16 = this.get16BitAddress(remoteDevice);
        if (addr16 != null && !addr16.equals(XBee16BitAddress.UNKNOWN_ADDRESS)) {
            Collection<RemoteXBeeDevice> devices = this.remotesBy64BitAddr.values();
            for (RemoteXBeeDevice d : devices) {
                XBee16BitAddress a = this.get16BitAddress(d);
                if (a == null || !a.equals(addr16)) continue;
                this.remotesBy64BitAddr.remove(d.get64BitAddress());
                return;
            }
            devInNetwork = this.remotesBy16BitAddr.get(addr16);
            if (devInNetwork != null) {
                this.remotesBy16BitAddr.remove(addr16);
                return;
            }
        }
        if ((addr64 == null || addr64.equals(XBee64BitAddress.UNKNOWN_ADDRESS)) && (addr16 == null || addr16.equals(XBee16BitAddress.UNKNOWN_ADDRESS))) {
            this.logger.error("{}Remote device '{}' cannot be removed: 64-bit and 16-bit addresses must be specified.", (Object)this.localDevice.toString(), (Object)remoteDevice.toString());
        }
    }

    public void clearDeviceList() {
        this.logger.debug("{}Clearing the network.", (Object)this.localDevice.toString());
        this.remotesBy64BitAddr.clear();
        this.remotesBy16BitAddr.clear();
    }

    public int getNumberOfDevices() {
        return this.remotesBy64BitAddr.size() + this.remotesBy16BitAddr.size();
    }

    private XBee16BitAddress get16BitAddress(RemoteXBeeDevice device) {
        if (device == null) {
            return null;
        }
        XBee16BitAddress address = null;
        switch (device.getXBeeProtocol()) {
            case RAW_802_15_4: {
                address = ((RemoteRaw802Device)device).get16BitAddress();
                break;
            }
            case ZIGBEE: {
                address = ((RemoteZigBeeDevice)device).get16BitAddress();
                break;
            }
            default: {
                address = device.get16BitAddress();
            }
        }
        return address;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.localDevice.toString() + "] @" + Integer.toHexString(this.hashCode());
    }
}

