/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import android.content.Context;
import com.digi.xbee.api.AbstractXBeeDevice;
import com.digi.xbee.api.Raw802Device;
import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.XBee;
import com.digi.xbee.api.XBeeNetwork;
import com.digi.xbee.api.connection.DataReader;
import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.connection.android.AndroidUSBPermissionListener;
import com.digi.xbee.api.connection.serial.SerialPortParameters;
import com.digi.xbee.api.exceptions.ATCommandException;
import com.digi.xbee.api.exceptions.InterfaceAlreadyOpenException;
import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.InvalidOperatingModeException;
import com.digi.xbee.api.exceptions.OperationNotSupportedException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.listeners.IDataReceiveListener;
import com.digi.xbee.api.listeners.IIOSampleReceiveListener;
import com.digi.xbee.api.listeners.IModemStatusReceiveListener;
import com.digi.xbee.api.listeners.IPacketReceiveListener;
import com.digi.xbee.api.models.APIOutputMode;
import com.digi.xbee.api.models.ATCommand;
import com.digi.xbee.api.models.ATCommandResponse;
import com.digi.xbee.api.models.ExplicitXBeeMessage;
import com.digi.xbee.api.models.ModemStatusEvent;
import com.digi.xbee.api.models.OperatingMode;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeMessage;
import com.digi.xbee.api.models.XBeePacketsQueue;
import com.digi.xbee.api.models.XBeeProtocol;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.packet.XBeePacket;
import com.digi.xbee.api.packet.common.ExplicitAddressingPacket;
import com.digi.xbee.api.packet.common.ExplicitRxIndicatorPacket;
import com.digi.xbee.api.packet.common.ReceivePacket;
import com.digi.xbee.api.packet.common.TransmitPacket;
import com.digi.xbee.api.packet.raw.RX16Packet;
import com.digi.xbee.api.packet.raw.RX64Packet;
import com.digi.xbee.api.packet.raw.TX64Packet;
import com.digi.xbee.api.utils.HexUtils;
import java.io.IOException;

public class XBeeDevice
extends AbstractXBeeDevice {
    private static int TIMEOUT_RESET = 5000;
    protected static int TIMEOUT_READ_PACKET = 3000;
    private static String COMMAND_MODE_CHAR = "+";
    private static String COMMAND_MODE_OK = "OK\r";
    protected XBeeNetwork network;
    private Object resetLock = new Object();
    private boolean modemStatusReceived = false;
    private IModemStatusReceiveListener resetStatusListener = new IModemStatusReceiveListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void modemStatusEventReceived(ModemStatusEvent modemStatusEvent) {
            if (modemStatusEvent == ModemStatusEvent.STATUS_HARDWARE_RESET || modemStatusEvent == ModemStatusEvent.STATUS_WATCHDOG_TIMER_RESET) {
                XBeeDevice.this.modemStatusReceived = true;
                Object object = XBeeDevice.this.resetLock;
                synchronized (object) {
                    XBeeDevice.this.resetLock.notify();
                }
            }
        }
    };

    public XBeeDevice(String port, int baudRate) {
        super(port, baudRate);
    }

    public XBeeDevice(String port, int baudRate, int dataBits, int stopBits, int parity, int flowControl) {
        super(port, baudRate, dataBits, stopBits, parity, flowControl);
    }

    public XBeeDevice(String port, SerialPortParameters serialPortParameters) {
        super(port, serialPortParameters);
    }

    public XBeeDevice(Context context, int baudRate) {
        super(XBee.createConnectiontionInterface(context, baudRate));
    }

    public XBeeDevice(Context context, int baudRate, AndroidUSBPermissionListener permissionListener) {
        super(XBee.createConnectiontionInterface(context, baudRate, permissionListener));
    }

    public XBeeDevice(Context context, String port, int baudRate) {
        super(XBee.createConnectiontionInterface(context, port, baudRate));
    }

    public XBeeDevice(Context context, String port, SerialPortParameters parameters) {
        super(XBee.createConnectiontionInterface(context, port, parameters));
    }

    public XBeeDevice(IConnectionInterface connectionInterface) {
        super(connectionInterface);
    }

    public void open() throws XBeeException {
        this.logger.info(this.toString() + "Opening the connection interface...");
        if (this.connectionInterface.isOpen()) {
            throw new InterfaceAlreadyOpenException();
        }
        this.connectionInterface.open();
        this.logger.info(this.toString() + "Connection interface open.");
        this.dataReader = new DataReader(this.connectionInterface, this.operatingMode, this);
        this.dataReader.start();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.operatingMode == OperatingMode.UNKNOWN) {
            this.operatingMode = this.determineOperatingMode();
        }
        if (this.operatingMode == OperatingMode.UNKNOWN) {
            this.close();
            throw new InvalidOperatingModeException("Could not determine operating mode.");
        }
        if (this.operatingMode == OperatingMode.AT) {
            this.close();
            throw new InvalidOperatingModeException(this.operatingMode);
        }
        try {
            this.readDeviceInfo();
        }
        catch (ATCommandException e) {
            throw new XBeeException("Error reading device information.", e);
        }
    }

    public void close() {
        if (this.dataReader != null && this.dataReader.isRunning()) {
            this.dataReader.stopReader();
        }
        this.connectionInterface.close();
        this.logger.info(this.toString() + "Connection interface closed.");
    }

    public boolean isOpen() {
        if (this.connectionInterface != null) {
            return this.connectionInterface.isOpen();
        }
        return false;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    public XBeeNetwork getNetwork() {
        if (!this.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        if (this.network == null) {
            this.network = new XBeeNetwork(this);
        }
        return this.network;
    }

    @Override
    public OperatingMode getOperatingMode() {
        return super.getOperatingMode();
    }

    @Override
    protected int getNextFrameID() {
        return super.getNextFrameID();
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(int receiveTimeout) {
        if (receiveTimeout < 0) {
            throw new IllegalArgumentException("Receive timeout cannot be less than 0.");
        }
        this.receiveTimeout = receiveTimeout;
    }

    protected OperatingMode determineOperatingMode() throws OperationNotSupportedException {
        try {
            this.operatingMode = OperatingMode.API;
            this.dataReader.setXBeeReaderMode(this.operatingMode);
            ATCommandResponse response = this.sendATCommand(new ATCommand("AP"));
            if (response.getResponse() != null && response.getResponse().length > 0) {
                if (response.getResponse()[0] != OperatingMode.API.getID()) {
                    this.operatingMode = OperatingMode.API_ESCAPE;
                    this.dataReader.setXBeeReaderMode(this.operatingMode);
                }
                this.logger.debug(this.toString() + "Using {}.", (Object)this.operatingMode.getName());
                return this.operatingMode;
            }
        }
        catch (TimeoutException e) {
            this.operatingMode = OperatingMode.AT;
            this.dataReader.setXBeeReaderMode(this.operatingMode);
            try {
                Thread.sleep(1200L);
                boolean success = this.enterATCommandMode();
                if (success) {
                    return OperatingMode.AT;
                }
            }
            catch (TimeoutException e1) {
                this.logger.error(e1.getMessage(), (Throwable)e1);
            }
            catch (InvalidOperatingModeException e1) {
                this.logger.error(e1.getMessage(), (Throwable)e1);
            }
            catch (InterruptedException e1) {
                this.logger.error(e1.getMessage(), (Throwable)e1);
            }
        }
        catch (InvalidOperatingModeException e) {
            this.logger.error("Invalid operating mode", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return OperatingMode.UNKNOWN;
    }

    private boolean enterATCommandMode() throws InvalidOperatingModeException, TimeoutException {
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        if (this.operatingMode != OperatingMode.AT) {
            throw new InvalidOperatingModeException("Invalid mode. Command mode can be only accessed while in AT mode.");
        }
        byte[] readData = new byte[256];
        try {
            this.connectionInterface.writeData(COMMAND_MODE_CHAR.getBytes());
            this.connectionInterface.writeData(COMMAND_MODE_CHAR.getBytes());
            this.connectionInterface.writeData(COMMAND_MODE_CHAR.getBytes());
            Thread.sleep(1500L);
            int readBytes = this.connectionInterface.readData(readData);
            if (readBytes < COMMAND_MODE_OK.length()) {
                throw new TimeoutException();
            }
            String readString = new String(readData, 0, readBytes);
            return readString.contains(COMMAND_MODE_OK);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    public void addPacketListener(IPacketReceiveListener listener) {
        super.addPacketListener(listener);
    }

    @Override
    public void removePacketListener(IPacketReceiveListener listener) {
        super.removePacketListener(listener);
    }

    @Override
    public void addDataListener(IDataReceiveListener listener) {
        super.addDataListener(listener);
    }

    @Override
    public void removeDataListener(IDataReceiveListener listener) {
        super.removeDataListener(listener);
    }

    @Override
    public void addIOSampleListener(IIOSampleReceiveListener listener) {
        super.addIOSampleListener(listener);
    }

    @Override
    public void removeIOSampleListener(IIOSampleReceiveListener listener) {
        super.removeIOSampleListener(listener);
    }

    @Override
    public void addModemStatusListener(IModemStatusReceiveListener listener) {
        super.addModemStatusListener(listener);
    }

    @Override
    public void removeModemStatusListener(IModemStatusReceiveListener listener) {
        super.removeModemStatusListener(listener);
    }

    protected void sendDataAsync(XBee64BitAddress address, byte[] data) throws XBeeException {
        XBeeAPIPacket xbeePacket;
        if (address == null) {
            throw new NullPointerException("Address cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send data to a remote device from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending data asynchronously to {} >> {}.", (Object)address, (Object)HexUtils.prettyHexString(data));
        switch (this.getXBeeProtocol()) {
            case RAW_802_15_4: {
                xbeePacket = new TX64Packet(this.getNextFrameID(), address, 0, data);
                break;
            }
            default: {
                xbeePacket = new TransmitPacket(this.getNextFrameID(), address, XBee16BitAddress.UNKNOWN_ADDRESS, 0, 0, data);
            }
        }
        this.sendAndCheckXBeePacket(xbeePacket, true);
    }

    protected void sendDataAsync(XBee64BitAddress address64Bit, XBee16BitAddress address16Bit, byte[] data) throws XBeeException {
        if (address64Bit == null) {
            throw new NullPointerException("64-bit address cannot be null");
        }
        if (address16Bit == null) {
            throw new NullPointerException("16-bit address cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send data to a remote device from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending data asynchronously to {}[{}] >> {}.", new Object[]{address64Bit, address16Bit, HexUtils.prettyHexString(data)});
        TransmitPacket xbeePacket = new TransmitPacket(this.getNextFrameID(), address64Bit, address16Bit, 0, 0, data);
        this.sendAndCheckXBeePacket(xbeePacket, true);
    }

    public void sendDataAsync(RemoteXBeeDevice remoteXBeeDevice, byte[] data) throws XBeeException {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null");
        }
        switch (this.getXBeeProtocol()) {
            case ZIGBEE: 
            case DIGI_POINT: {
                if (remoteXBeeDevice.get64BitAddress() != null && remoteXBeeDevice.get16BitAddress() != null) {
                    this.sendDataAsync(remoteXBeeDevice.get64BitAddress(), remoteXBeeDevice.get16BitAddress(), data);
                    break;
                }
                this.sendDataAsync(remoteXBeeDevice.get64BitAddress(), data);
                break;
            }
            case RAW_802_15_4: {
                if (this instanceof Raw802Device) {
                    if (remoteXBeeDevice.get64BitAddress() != null) {
                        ((Raw802Device)this).sendDataAsync(remoteXBeeDevice.get64BitAddress(), data);
                        break;
                    }
                    ((Raw802Device)this).sendDataAsync(remoteXBeeDevice.get16BitAddress(), data);
                    break;
                }
                this.sendDataAsync(remoteXBeeDevice.get64BitAddress(), data);
                break;
            }
            default: {
                this.sendDataAsync(remoteXBeeDevice.get64BitAddress(), data);
            }
        }
    }

    protected void sendData(XBee64BitAddress address, byte[] data) throws TimeoutException, XBeeException {
        XBeeAPIPacket xbeePacket;
        if (address == null) {
            throw new NullPointerException("Address cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send data to a remote device from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending data to {} >> {}.", (Object)address, (Object)HexUtils.prettyHexString(data));
        switch (this.getXBeeProtocol()) {
            case RAW_802_15_4: {
                xbeePacket = new TX64Packet(this.getNextFrameID(), address, 0, data);
                break;
            }
            default: {
                xbeePacket = new TransmitPacket(this.getNextFrameID(), address, XBee16BitAddress.UNKNOWN_ADDRESS, 0, 0, data);
            }
        }
        this.sendAndCheckXBeePacket(xbeePacket, false);
    }

    protected void sendData(XBee64BitAddress address64Bit, XBee16BitAddress address16Bit, byte[] data) throws TimeoutException, XBeeException {
        if (address64Bit == null) {
            throw new NullPointerException("64-bit address cannot be null");
        }
        if (address16Bit == null) {
            throw new NullPointerException("16-bit address cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send data to a remote device from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending data to {}[{}] >> {}.", new Object[]{address64Bit, address16Bit, HexUtils.prettyHexString(data)});
        TransmitPacket xbeePacket = new TransmitPacket(this.getNextFrameID(), address64Bit, address16Bit, 0, 0, data);
        this.sendAndCheckXBeePacket(xbeePacket, false);
    }

    public void sendData(RemoteXBeeDevice remoteXBeeDevice, byte[] data) throws TimeoutException, XBeeException {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null");
        }
        switch (this.getXBeeProtocol()) {
            case ZIGBEE: 
            case DIGI_POINT: {
                if (remoteXBeeDevice.get64BitAddress() != null && remoteXBeeDevice.get16BitAddress() != null) {
                    this.sendData(remoteXBeeDevice.get64BitAddress(), remoteXBeeDevice.get16BitAddress(), data);
                    break;
                }
                this.sendData(remoteXBeeDevice.get64BitAddress(), data);
                break;
            }
            case RAW_802_15_4: {
                if (this instanceof Raw802Device) {
                    if (remoteXBeeDevice.get64BitAddress() != null) {
                        ((Raw802Device)this).sendData(remoteXBeeDevice.get64BitAddress(), data);
                        break;
                    }
                    ((Raw802Device)this).sendData(remoteXBeeDevice.get16BitAddress(), data);
                    break;
                }
                this.sendData(remoteXBeeDevice.get64BitAddress(), data);
                break;
            }
            default: {
                this.sendData(remoteXBeeDevice.get64BitAddress(), data);
            }
        }
    }

    public void sendBroadcastData(byte[] data) throws TimeoutException, XBeeException {
        this.sendData(XBee64BitAddress.BROADCAST_ADDRESS, data);
    }

    protected void sendExplicitDataAsync(XBee64BitAddress address, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws XBeeException {
        if (address == null) {
            throw new NullPointerException("Address cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        if (sourceEndpoint < 0 || sourceEndpoint > 255) {
            throw new IllegalArgumentException("Source endpoint must be between 0 and 0xFF.");
        }
        if (destEndpoint < 0 || destEndpoint > 255) {
            throw new IllegalArgumentException("Destination endpoint must be between 0 and 0xFF.");
        }
        if (clusterID < 0 || clusterID > 65535) {
            throw new IllegalArgumentException("Cluster ID must be between 0 and 0xFFFF.");
        }
        if (profileID < 0 || profileID > 65535) {
            throw new IllegalArgumentException("Profile ID must be between 0 and 0xFFFF.");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send explicit data to a remote device from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending explicit data asynchronously to {} [{} - {} - {} - {}] >> {}.", new Object[]{address, String.format("%02X", sourceEndpoint), String.format("%02X", destEndpoint), String.format("%04X", clusterID), String.format("%04X", profileID), HexUtils.prettyHexString(data)});
        ExplicitAddressingPacket xbeePacket = new ExplicitAddressingPacket(this.getNextFrameID(), address, XBee16BitAddress.UNKNOWN_ADDRESS, sourceEndpoint, destEndpoint, clusterID, profileID, 0, 0, data);
        this.sendAndCheckXBeePacket(xbeePacket, true);
    }

    protected void sendExplicitDataAsync(XBee64BitAddress address64Bit, XBee16BitAddress address16Bit, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws XBeeException {
        if (address64Bit == null) {
            throw new NullPointerException("64-bit address cannot be null.");
        }
        if (address16Bit == null) {
            throw new NullPointerException("16-bit address cannot be null.");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        if (sourceEndpoint < 0 || sourceEndpoint > 255) {
            throw new IllegalArgumentException("Source endpoint must be between 0 and 0xFF.");
        }
        if (destEndpoint < 0 || destEndpoint > 255) {
            throw new IllegalArgumentException("Destination endpoint must be between 0 and 0xFF.");
        }
        if (clusterID < 0 || clusterID > 65535) {
            throw new IllegalArgumentException("Cluster ID must be between 0 and 0xFFFF.");
        }
        if (profileID < 0 || profileID > 65535) {
            throw new IllegalArgumentException("Profile ID must be between 0 and 0xFFFF.");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send explicit data to a remote device from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending explicit data asynchronously to {}[{}] [{} - {} - {} - {}] >> {}.", new Object[]{address64Bit, address16Bit, String.format("%02X", sourceEndpoint), String.format("%02X", destEndpoint), String.format("%04X", clusterID), String.format("%04X", profileID), HexUtils.prettyHexString(data)});
        ExplicitAddressingPacket xbeePacket = new ExplicitAddressingPacket(this.getNextFrameID(), address64Bit, address16Bit, sourceEndpoint, destEndpoint, clusterID, profileID, 0, 0, data);
        this.sendAndCheckXBeePacket(xbeePacket, true);
    }

    protected void sendExplicitDataAsync(RemoteXBeeDevice remoteXBeeDevice, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws XBeeException {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null");
        }
        switch (this.getXBeeProtocol()) {
            case ZIGBEE: 
            case DIGI_POINT: {
                if (remoteXBeeDevice.get64BitAddress() != null && remoteXBeeDevice.get16BitAddress() != null) {
                    this.sendExplicitDataAsync(remoteXBeeDevice.get64BitAddress(), remoteXBeeDevice.get16BitAddress(), sourceEndpoint, destEndpoint, clusterID, profileID, data);
                    break;
                }
                this.sendExplicitDataAsync(remoteXBeeDevice.get64BitAddress(), sourceEndpoint, destEndpoint, clusterID, profileID, data);
                break;
            }
            case RAW_802_15_4: {
                throw new OperationNotSupportedException("802.15.4. protocol does not support explicit data transmissions.");
            }
            default: {
                this.sendExplicitDataAsync(remoteXBeeDevice.get64BitAddress(), sourceEndpoint, destEndpoint, clusterID, profileID, data);
            }
        }
    }

    protected void sendExplicitData(XBee64BitAddress address, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws TimeoutException, XBeeException {
        if (address == null) {
            throw new NullPointerException("Address cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        if (sourceEndpoint < 0 || sourceEndpoint > 255) {
            throw new IllegalArgumentException("Source endpoint must be between 0 and 0xFF.");
        }
        if (destEndpoint < 0 || destEndpoint > 255) {
            throw new IllegalArgumentException("Destination endpoint must be between 0 and 0xFF.");
        }
        if (clusterID < 0 || clusterID > 65535) {
            throw new IllegalArgumentException("Cluster ID must be between 0 and 0xFFFF.");
        }
        if (profileID < 0 || profileID > 65535) {
            throw new IllegalArgumentException("Profile ID must be between 0 and 0xFFFF.");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send explicit data to a remote device from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending explicit data to {} [{} - {} - {} - {}] >> {}.", new Object[]{address, String.format("%02X", sourceEndpoint), String.format("%02X", destEndpoint), String.format("%04X", clusterID), String.format("%04X", profileID), HexUtils.prettyHexString(data)});
        ExplicitAddressingPacket xbeePacket = new ExplicitAddressingPacket(this.getNextFrameID(), address, XBee16BitAddress.UNKNOWN_ADDRESS, sourceEndpoint, destEndpoint, clusterID, profileID, 0, 0, data);
        this.sendAndCheckXBeePacket(xbeePacket, false);
    }

    protected void sendExplicitData(XBee64BitAddress address64Bit, XBee16BitAddress address16Bit, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws TimeoutException, XBeeException {
        if (address64Bit == null) {
            throw new NullPointerException("64-bit address cannot be null");
        }
        if (address16Bit == null) {
            throw new NullPointerException("16-bit address cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        if (sourceEndpoint < 0 || sourceEndpoint > 255) {
            throw new IllegalArgumentException("Source endpoint must be between 0 and 0xFF.");
        }
        if (destEndpoint < 0 || destEndpoint > 255) {
            throw new IllegalArgumentException("Destination endpoint must be between 0 and 0xFF.");
        }
        if (clusterID < 0 || clusterID > 65535) {
            throw new IllegalArgumentException("Cluster ID must be between 0 and 0xFFFF.");
        }
        if (profileID < 0 || profileID > 65535) {
            throw new IllegalArgumentException("Profile ID must be between 0 and 0xFFFF.");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send explicit data to a remote device from a remote device.");
        }
        this.logger.debug(this.toString() + "Sending explicit data to {}[{}] [{} - {} - {} - {}] >> {}.", new Object[]{address64Bit, address16Bit, String.format("%02X", sourceEndpoint), String.format("%02X", destEndpoint), String.format("%04X", clusterID), String.format("%04X", profileID), HexUtils.prettyHexString(data)});
        ExplicitAddressingPacket xbeePacket = new ExplicitAddressingPacket(this.getNextFrameID(), address64Bit, address16Bit, sourceEndpoint, destEndpoint, clusterID, profileID, 0, 0, data);
        this.sendAndCheckXBeePacket(xbeePacket, false);
    }

    protected void sendExplicitData(RemoteXBeeDevice remoteXBeeDevice, int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws TimeoutException, XBeeException {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null.");
        }
        switch (this.getXBeeProtocol()) {
            case ZIGBEE: 
            case DIGI_POINT: {
                if (remoteXBeeDevice.get64BitAddress() != null && remoteXBeeDevice.get16BitAddress() != null) {
                    this.sendExplicitData(remoteXBeeDevice.get64BitAddress(), remoteXBeeDevice.get16BitAddress(), sourceEndpoint, destEndpoint, clusterID, profileID, data);
                    break;
                }
                this.sendExplicitData(remoteXBeeDevice.get64BitAddress(), sourceEndpoint, destEndpoint, clusterID, profileID, data);
                break;
            }
            case RAW_802_15_4: {
                throw new OperationNotSupportedException("802.15.4. protocol does not support explicit data transmissions.");
            }
            default: {
                this.sendExplicitData(remoteXBeeDevice.get64BitAddress(), sourceEndpoint, destEndpoint, clusterID, profileID, data);
            }
        }
    }

    protected void sendBroadcastExplicitData(int sourceEndpoint, int destEndpoint, int clusterID, int profileID, byte[] data) throws TimeoutException, XBeeException {
        if (this.getXBeeProtocol() == XBeeProtocol.RAW_802_15_4) {
            throw new OperationNotSupportedException("802.15.4. protocol does not support explicit data transmissions.");
        }
        this.sendExplicitData(XBee64BitAddress.BROADCAST_ADDRESS, sourceEndpoint, destEndpoint, clusterID, profileID, data);
    }

    public void sendPacket(XBeePacket packet, IPacketReceiveListener packetReceiveListener) throws XBeeException {
        try {
            this.sendXBeePacket(packet, packetReceiveListener);
        }
        catch (IOException e) {
            throw new XBeeException("Error writing in the communication interface.", e);
        }
    }

    public void sendPacketAsync(XBeePacket packet) throws XBeeException {
        try {
            super.sendXBeePacket(packet, null);
        }
        catch (IOException e) {
            throw new XBeeException("Error writing in the communication interface.", e);
        }
    }

    public XBeePacket sendPacket(XBeePacket packet) throws TimeoutException, XBeeException {
        try {
            return super.sendXBeePacket(packet);
        }
        catch (IOException e) {
            throw new XBeeException("Error writing in the communication interface.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForModemResetStatusPacket() {
        this.modemStatusReceived = false;
        this.addModemStatusListener(this.resetStatusListener);
        Object object = this.resetLock;
        synchronized (object) {
            try {
                this.resetLock.wait(TIMEOUT_RESET);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.removeModemStatusListener(this.resetStatusListener);
        return this.modemStatusReceived;
    }

    @Override
    public void reset() throws TimeoutException, XBeeException {
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        this.logger.info(this.toString() + "Resetting the local module...");
        ATCommandResponse response = null;
        try {
            response = this.sendATCommand(new ATCommand("FR"));
        }
        catch (IOException e) {
            throw new XBeeException("Error writing in the communication interface.", e);
        }
        this.checkATCommandResponseIsValid(response);
        if (!this.waitForModemResetStatusPacket()) {
            throw new TimeoutException("Timeout waiting for the Modem Status packet.");
        }
        this.logger.info(this.toString() + "Module reset successfully.");
    }

    public XBeeMessage readData() {
        return this.readDataPacket(null, TIMEOUT_READ_PACKET);
    }

    public XBeeMessage readData(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Read timeout must be 0 or greater.");
        }
        return this.readDataPacket(null, timeout);
    }

    public XBeeMessage readDataFrom(RemoteXBeeDevice remoteXBeeDevice) {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null.");
        }
        return this.readDataPacket(remoteXBeeDevice, TIMEOUT_READ_PACKET);
    }

    public XBeeMessage readDataFrom(RemoteXBeeDevice remoteXBeeDevice, int timeout) {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null.");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Read timeout must be 0 or greater.");
        }
        return this.readDataPacket(remoteXBeeDevice, timeout);
    }

    private XBeeMessage readDataPacket(RemoteXBeeDevice remoteXBeeDevice, int timeout) {
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        XBeePacketsQueue xbeePacketsQueue = this.dataReader.getXBeePacketsQueue();
        XBeePacket xbeePacket = null;
        xbeePacket = remoteXBeeDevice != null ? xbeePacketsQueue.getFirstDataPacketFrom(remoteXBeeDevice, timeout) : xbeePacketsQueue.getFirstDataPacket(timeout);
        if (xbeePacket == null) {
            return null;
        }
        RemoteXBeeDevice remoteDevice = null;
        try {
            remoteDevice = this.dataReader.getRemoteXBeeDeviceFromPacket((XBeeAPIPacket)xbeePacket);
            if (remoteXBeeDevice != null) {
                remoteDevice = this.getNetwork().addRemoteDevice(remoteXBeeDevice);
            }
            if (remoteDevice == null) {
                return null;
            }
        }
        catch (XBeeException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        byte[] data = null;
        switch (((XBeeAPIPacket)xbeePacket).getFrameType()) {
            case RECEIVE_PACKET: {
                ReceivePacket receivePacket = (ReceivePacket)xbeePacket;
                data = receivePacket.getRFData();
                break;
            }
            case RX_16: {
                RX16Packet rx16Packet = (RX16Packet)xbeePacket;
                data = rx16Packet.getRFData();
                break;
            }
            case RX_64: {
                RX64Packet rx64Packet = (RX64Packet)xbeePacket;
                data = rx64Packet.getRFData();
                break;
            }
            default: {
                return null;
            }
        }
        return new XBeeMessage(remoteDevice, data, ((XBeeAPIPacket)xbeePacket).isBroadcast());
    }

    protected ExplicitXBeeMessage readExplicitData() {
        return this.readExplicitDataPacket(null, TIMEOUT_READ_PACKET);
    }

    protected ExplicitXBeeMessage readExplicitData(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Read timeout must be 0 or greater.");
        }
        return this.readExplicitDataPacket(null, timeout);
    }

    protected ExplicitXBeeMessage readExplicitDataFrom(RemoteXBeeDevice remoteXBeeDevice) {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null.");
        }
        return this.readExplicitDataPacket(remoteXBeeDevice, TIMEOUT_READ_PACKET);
    }

    protected ExplicitXBeeMessage readExplicitDataFrom(RemoteXBeeDevice remoteXBeeDevice, int timeout) {
        if (remoteXBeeDevice == null) {
            throw new NullPointerException("Remote XBee device cannot be null.");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Read timeout must be 0 or greater.");
        }
        return this.readExplicitDataPacket(remoteXBeeDevice, timeout);
    }

    private ExplicitXBeeMessage readExplicitDataPacket(RemoteXBeeDevice remoteXBeeDevice, int timeout) {
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        XBeePacketsQueue xbeePacketsQueue = this.dataReader.getXBeePacketsQueue();
        XBeePacket xbeePacket = null;
        xbeePacket = remoteXBeeDevice != null ? xbeePacketsQueue.getFirstExplicitDataPacketFrom(remoteXBeeDevice, timeout) : xbeePacketsQueue.getFirstExplicitDataPacket(timeout);
        if (xbeePacket == null) {
            return null;
        }
        APIFrameType packetType = ((XBeeAPIPacket)xbeePacket).getFrameType();
        if (packetType != APIFrameType.EXPLICIT_RX_INDICATOR) {
            return null;
        }
        ExplicitRxIndicatorPacket explicitDataPacket = (ExplicitRxIndicatorPacket)xbeePacket;
        RemoteXBeeDevice remoteDevice = this.getNetwork().getDevice(explicitDataPacket.get64BitSourceAddress());
        if (remoteDevice == null) {
            remoteDevice = remoteXBeeDevice != null ? remoteXBeeDevice : new RemoteXBeeDevice(this, explicitDataPacket.get64BitSourceAddress());
            this.getNetwork().addRemoteDevice(remoteDevice);
        }
        int sourceEndpoint = explicitDataPacket.getSourceEndpoint();
        int destEndpoint = explicitDataPacket.getDestinationEndpoint();
        int clusterID = explicitDataPacket.getClusterID();
        int profileID = explicitDataPacket.getProfileID();
        byte[] data = explicitDataPacket.getRFData();
        return new ExplicitXBeeMessage(remoteDevice, sourceEndpoint, destEndpoint, clusterID, profileID, data, ((XBeeAPIPacket)xbeePacket).isBroadcast());
    }

    protected void setAPIOutputMode(APIOutputMode apiOutputMode) throws TimeoutException, XBeeException {
        if (apiOutputMode == null) {
            throw new NullPointerException("API output mode cannot be null.");
        }
        this.setParameter("AO", new byte[]{(byte)apiOutputMode.getValue()});
    }

    protected APIOutputMode getAPIOutputMode() throws TimeoutException, XBeeException {
        byte[] apiOutputModeValue = this.getParameter("AO");
        return APIOutputMode.get(apiOutputModeValue[0]);
    }

    @Override
    public String toString() {
        String addr64;
        String id = this.getNodeID() == null ? "" : this.getNodeID();
        String string = addr64 = this.get64BitAddress() == null || this.get64BitAddress().equals(XBee64BitAddress.UNKNOWN_ADDRESS) ? "" : this.get64BitAddress().toString();
        if (id.length() == 0 && addr64.length() == 0) {
            return super.toString();
        }
        StringBuilder message = new StringBuilder(super.toString());
        message.append(addr64);
        if (id.length() > 0) {
            message.append(" (");
            message.append(id);
            message.append(")");
        }
        message.append(" - ");
        return message.toString();
    }
}

