/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import android.content.Context;
import com.digi.xbee.api.IPv6Device;
import com.digi.xbee.api.XBee;
import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.connection.android.AndroidUSBPermissionListener;
import com.digi.xbee.api.connection.serial.SerialPortParameters;
import com.digi.xbee.api.exceptions.OperationNotSupportedException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeDeviceException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.models.AssociationIndicationStatus;
import com.digi.xbee.api.models.HTTPMethodEnum;
import com.digi.xbee.api.models.IPProtocol;
import com.digi.xbee.api.models.ThreadAssociationIndicationStatus;
import com.digi.xbee.api.models.XBeeProtocol;
import com.digi.xbee.api.packet.thread.CoAPTxRequestPacket;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.net.Inet6Address;

public class ThreadDevice
extends IPv6Device {
    private static final String OPERATION_EXCEPTION = "Operation not supported in Thread protocol.";
    private static final String ERROR_PROTOCOL_ILLEGAL = String.format("Protocol must be %s or %s.", IPProtocol.UDP.getName(), IPProtocol.COAP.getName());

    public ThreadDevice(String port, int baudRate) {
        this(XBee.createConnectiontionInterface(port, baudRate));
    }

    public ThreadDevice(String port, int baudRate, int dataBits, int stopBits, int parity, int flowControl) {
        this(port, new SerialPortParameters(baudRate, dataBits, stopBits, parity, flowControl));
    }

    public ThreadDevice(String port, SerialPortParameters serialPortParameters) {
        this(XBee.createConnectiontionInterface(port, serialPortParameters));
    }

    public ThreadDevice(Context context, int baudRate) {
        super(XBee.createConnectiontionInterface(context, baudRate));
    }

    public ThreadDevice(Context context, int baudRate, AndroidUSBPermissionListener permissionListener) {
        super(XBee.createConnectiontionInterface(context, baudRate, permissionListener));
    }

    public ThreadDevice(Context context, String port, int baudRate) {
        super(XBee.createConnectiontionInterface(context, port, baudRate));
    }

    public ThreadDevice(Context context, String port, SerialPortParameters parameters) {
        super(XBee.createConnectiontionInterface(context, port, parameters));
    }

    public ThreadDevice(IConnectionInterface connectionInterface) {
        super(connectionInterface);
    }

    @Override
    public void open() throws XBeeException {
        super.open();
        if (this.xbeeProtocol != XBeeProtocol.THREAD) {
            throw new XBeeDeviceException("XBee device is not a " + this.getXBeeProtocol().getDescription() + " device, it is a " + this.xbeeProtocol.getDescription() + " device.");
        }
    }

    @Override
    public XBeeProtocol getXBeeProtocol() {
        return XBeeProtocol.THREAD;
    }

    public boolean isConnected() throws TimeoutException, XBeeException {
        ThreadAssociationIndicationStatus status = this.getThreadAssociationIndicationStatus();
        return status == ThreadAssociationIndicationStatus.ASSOCIATED;
    }

    public ThreadAssociationIndicationStatus getThreadAssociationIndicationStatus() throws TimeoutException, XBeeException {
        byte[] associationIndicationValue = this.getParameter("AI");
        return ThreadAssociationIndicationStatus.get(ByteUtils.byteArrayToInt(associationIndicationValue));
    }

    @Override
    protected AssociationIndicationStatus getAssociationIndicationStatus() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    public byte[] sendCoAPData(Inet6Address ipv6Address, String uri, HTTPMethodEnum method, byte[] data) throws TimeoutException, IllegalArgumentException, XBeeException {
        boolean applyChanges = uri.startsWith("XB/AT");
        return this.sendCoAPData(ipv6Address, uri, method, applyChanges, data, false);
    }

    public byte[] sendCoAPData(Inet6Address ipv6Address, String uri, HTTPMethodEnum method, boolean applyChanges, byte[] data) throws TimeoutException, IllegalArgumentException, XBeeException {
        return this.sendCoAPData(ipv6Address, uri, method, applyChanges, data, false);
    }

    public void sendCoAPDataAsync(Inet6Address ipv6Address, String uri, HTTPMethodEnum method, byte[] data) throws TimeoutException, IllegalArgumentException, XBeeException {
        boolean applyChanges = uri.startsWith("XB/AT");
        this.sendCoAPData(ipv6Address, uri, method, applyChanges, data, true);
    }

    public void sendCoAPDataAsync(Inet6Address ipv6Address, String uri, HTTPMethodEnum method, boolean applyChanges, byte[] data) throws TimeoutException, IllegalArgumentException, XBeeException {
        this.sendCoAPData(ipv6Address, uri, method, applyChanges, data, true);
    }

    private byte[] sendCoAPData(Inet6Address ipv6Address, String uri, HTTPMethodEnum method, boolean applyChanges, byte[] data, boolean async) throws TimeoutException, IllegalArgumentException, XBeeException {
        if (ipv6Address == null) {
            throw new NullPointerException("IPv6 address cannot be null");
        }
        if (uri == null) {
            throw new NullPointerException("Uri cannot be null");
        }
        if (method == null) {
            throw new NullPointerException("HTTP method cannot be null");
        }
        if (uri.startsWith("XB/AT") && uri.length() < "XB/AT".length() + 3) {
            throw new IllegalArgumentException("AT command URI must contain an AT command.");
        }
        if (this.isRemote()) {
            throw new OperationNotSupportedException("Cannot send CoAP IPv6 data from a remote device.");
        }
        if (async) {
            this.logger.debug(this.toString() + "Sending CoAP IPv6 data asynchronously to {} >> {}.", (Object)ipv6Address, (Object)HexUtils.prettyHexString(data));
        } else {
            this.logger.debug(this.toString() + "Sending CoAP IPv6 data to {} >> {}.", (Object)ipv6Address, (Object)HexUtils.prettyHexString(data));
        }
        CoAPTxRequestPacket coAPPacket = new CoAPTxRequestPacket(this.getNextFrameID(), applyChanges ? 2 : 0, method, ipv6Address, uri, data);
        return this.sendAndCheckCoAPPacket(coAPPacket, async);
    }

    @Override
    public void sendIPData(Inet6Address ipv6Address, int destPort, IPProtocol protocol, byte[] data) throws TimeoutException, XBeeException {
        if (protocol != IPProtocol.UDP && protocol != IPProtocol.COAP) {
            throw new IllegalArgumentException(ERROR_PROTOCOL_ILLEGAL);
        }
        super.sendIPData(ipv6Address, destPort, protocol, data);
    }

    @Override
    public void sendIPDataAsync(Inet6Address ipv6Address, int destPort, IPProtocol protocol, byte[] data) throws XBeeException {
        if (protocol != IPProtocol.UDP && protocol != IPProtocol.COAP) {
            throw new IllegalArgumentException(ERROR_PROTOCOL_ILLEGAL);
        }
        super.sendIPDataAsync(ipv6Address, destPort, protocol, data);
    }
}

