/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import com.digi.xbee.api.AbstractXBeeDevice;
import com.digi.xbee.api.XBeeDevice;
import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.models.ATCommand;
import com.digi.xbee.api.models.ATCommandResponse;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeProtocol;
import java.io.IOException;
import java.net.Inet6Address;

public class RemoteXBeeDevice
extends AbstractXBeeDevice {
    public RemoteXBeeDevice(XBeeDevice localXBeeDevice, XBee64BitAddress addr64) {
        super(localXBeeDevice, addr64);
    }

    public RemoteXBeeDevice(XBeeDevice localXBeeDevice, XBee64BitAddress addr64, XBee16BitAddress addr16, String ni) {
        super(localXBeeDevice, addr64, addr16, ni);
    }

    public RemoteXBeeDevice(XBeeDevice localXBeeDevice, Inet6Address ipv6Addr) {
        super(localXBeeDevice, ipv6Addr);
    }

    public RemoteXBeeDevice(XBeeDevice localXBeeDevice, Inet6Address ipv6Addr, String ni) {
        super(localXBeeDevice, ipv6Addr, ni);
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public void reset() throws TimeoutException, XBeeException {
        if (!this.connectionInterface.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        this.logger.info(this.toString() + "Resetting the remote module ({})...", (Object)this.get64BitAddress());
        ATCommandResponse response = null;
        try {
            response = this.sendATCommand(new ATCommand("FR"));
        }
        catch (IOException e) {
            throw new XBeeException("Error writing in the communication interface.", e);
        }
        catch (TimeoutException e) {
            if (this.localXBeeDevice.getXBeeProtocol() == XBeeProtocol.RAW_802_15_4) {
                return;
            }
            throw e;
        }
        this.checkATCommandResponseIsValid(response);
    }

    @Override
    public String toString() {
        String id = this.getNodeID();
        if (id == null) {
            id = "";
        }
        return String.format("%s - %s", this.get64BitAddress(), this.getNodeID());
    }
}

