/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.ThreadDevice;
import com.digi.xbee.api.XBeeDevice;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.models.AssociationIndicationStatus;
import com.digi.xbee.api.models.ThreadAssociationIndicationStatus;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeProtocol;
import com.digi.xbee.api.utils.ByteUtils;
import java.net.Inet6Address;

public class RemoteThreadDevice
extends RemoteXBeeDevice {
    private static final String OPERATION_EXCEPTION = "Operation not supported in Thread protocol.";

    public RemoteThreadDevice(ThreadDevice localXBeeDevice, Inet6Address ipv6Addr) {
        super((XBeeDevice)localXBeeDevice, ipv6Addr);
    }

    public RemoteThreadDevice(XBeeDevice localXBeeDevice, Inet6Address ipv6Addr) {
        super(localXBeeDevice, ipv6Addr);
        if (localXBeeDevice.getXBeeProtocol() != XBeeProtocol.THREAD) {
            throw new IllegalArgumentException("The protocol of the local XBee device is not " + XBeeProtocol.THREAD.getDescription() + ".");
        }
    }

    public RemoteThreadDevice(XBeeDevice localXBeeDevice, Inet6Address ipv6Addr, String ni) {
        super(localXBeeDevice, ipv6Addr, ni);
        if (localXBeeDevice.getXBeeProtocol() != XBeeProtocol.THREAD) {
            throw new IllegalArgumentException("The protocol of the local XBee device is not " + XBeeProtocol.THREAD.getDescription() + ".");
        }
    }

    @Override
    public XBeeProtocol getXBeeProtocol() {
        return XBeeProtocol.THREAD;
    }

    @Override
    protected AssociationIndicationStatus getAssociationIndicationStatus() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    public ThreadAssociationIndicationStatus getThreadAssociationIndicationStatus() throws TimeoutException, XBeeException {
        byte[] associationIndicationValue = this.getParameter("AI");
        return ThreadAssociationIndicationStatus.get(ByteUtils.byteArrayToInt(associationIndicationValue));
    }

    @Override
    public void forceDisassociate() throws TimeoutException, XBeeException {
        super.forceDisassociate();
    }

    @Override
    public XBee16BitAddress get16BitAddress() {
        return null;
    }

    @Override
    public XBee64BitAddress getDestinationAddress() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void setDestinationAddress(XBee64BitAddress xbee64BitAddress) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }
}

