/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import com.digi.xbee.api.DigiMeshDevice;
import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.XBeeDevice;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeProtocol;
import java.net.Inet6Address;

public class RemoteDigiMeshDevice
extends RemoteXBeeDevice {
    private static final String OPERATION_EXCEPTION = "Operation not supported in DigiMesh protocol.";

    public RemoteDigiMeshDevice(DigiMeshDevice localXBeeDevice, XBee64BitAddress addr64) {
        super((XBeeDevice)localXBeeDevice, addr64);
    }

    public RemoteDigiMeshDevice(XBeeDevice localXBeeDevice, XBee64BitAddress addr64) {
        super(localXBeeDevice, addr64);
        if (localXBeeDevice.getXBeeProtocol() != XBeeProtocol.DIGI_MESH) {
            throw new IllegalArgumentException("The protocol of the local XBee device is not " + XBeeProtocol.DIGI_MESH.getDescription() + ".");
        }
    }

    public RemoteDigiMeshDevice(XBeeDevice localXBeeDevice, XBee64BitAddress addr64, String id) {
        super(localXBeeDevice, addr64, null, id);
        if (localXBeeDevice.getXBeeProtocol() != XBeeProtocol.DIGI_MESH) {
            throw new IllegalArgumentException("The protocol of the local XBee device is not " + XBeeProtocol.DIGI_MESH.getDescription() + ".");
        }
    }

    @Override
    public XBeeProtocol getXBeeProtocol() {
        return XBeeProtocol.DIGI_MESH;
    }

    @Override
    public Inet6Address getIPv6Address() {
        return null;
    }

    @Override
    public Inet6Address getIPv6DestinationAddress() throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void setIPv6DestinationAddress(Inet6Address ipv6Address) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }
}

