/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import com.digi.xbee.api.RemoteDigiMeshDevice;
import com.digi.xbee.api.RemoteDigiPointDevice;
import com.digi.xbee.api.RemoteRaw802Device;
import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.RemoteZigBeeDevice;
import com.digi.xbee.api.XBeeDevice;
import com.digi.xbee.api.XBeeNetwork;
import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.listeners.IDiscoveryListener;
import com.digi.xbee.api.listeners.IPacketReceiveListener;
import com.digi.xbee.api.models.ATCommandStatus;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.models.XBeeProtocol;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.packet.XBeePacket;
import com.digi.xbee.api.packet.common.ATCommandPacket;
import com.digi.xbee.api.packet.common.ATCommandResponsePacket;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeDiscovery {
    private static final String ND_COMMAND = "ND";
    public static final long DEFAULT_TIMEOUT = 20000L;
    private static int globalFrameID = 1;
    private XBeeDevice xbeeDevice;
    private List<RemoteXBeeDevice> deviceList;
    private boolean discovering = false;
    private boolean running = false;
    private int frameID;
    protected Logger logger;

    public NodeDiscovery(XBeeDevice xbeeDevice) {
        if (xbeeDevice == null) {
            throw new NullPointerException("Local XBee device cannot be null.");
        }
        this.xbeeDevice = xbeeDevice;
        this.frameID = globalFrameID++;
        if (globalFrameID == 255) {
            globalFrameID = 1;
        }
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public RemoteXBeeDevice discoverDevice(String id) throws XBeeException {
        if (!this.xbeeDevice.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        this.logger.debug("{}ND for {} device.", (Object)this.xbeeDevice.toString(), (Object)id);
        this.running = true;
        this.discovering = true;
        this.performNodeDiscovery(null, id);
        XBeeNetwork network = this.xbeeDevice.getNetwork();
        RemoteXBeeDevice rDevice = null;
        if (this.deviceList != null && this.deviceList.size() > 0 && (rDevice = this.deviceList.get(0)) != null) {
            rDevice = network.addRemoteDevice(rDevice);
        }
        return rDevice;
    }

    public List<RemoteXBeeDevice> discoverDevices(List<String> ids) throws XBeeException {
        if (!this.xbeeDevice.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        this.logger.debug("{}ND for all {} devices.", (Object)this.xbeeDevice.toString(), (Object)ids.toString());
        this.running = true;
        this.discovering = true;
        this.performNodeDiscovery(null, null);
        ArrayList<RemoteXBeeDevice> foundDevices = new ArrayList<RemoteXBeeDevice>(0);
        if (this.deviceList == null) {
            return foundDevices;
        }
        XBeeNetwork network = this.xbeeDevice.getNetwork();
        for (RemoteXBeeDevice d : this.deviceList) {
            String nID = d.getNodeID();
            if (nID == null) continue;
            for (String id : ids) {
                RemoteXBeeDevice rDevice;
                if (!nID.equals(id) || (rDevice = network.addRemoteDevice(d)) == null || foundDevices.contains(rDevice)) continue;
                foundDevices.add(rDevice);
            }
        }
        return foundDevices;
    }

    public void startDiscoveryProcess(final List<IDiscoveryListener> listeners) {
        if (!this.xbeeDevice.isOpen()) {
            throw new InterfaceNotOpenException();
        }
        if (listeners == null) {
            throw new NullPointerException("Listeners list cannot be null.");
        }
        this.running = true;
        this.discovering = true;
        Thread discoveryThread = new Thread(){

            @Override
            public void run() {
                try {
                    NodeDiscovery.this.performNodeDiscovery(listeners, null);
                }
                catch (XBeeException e) {
                    NodeDiscovery.this.notifyDiscoveryFinished(listeners, e.getMessage());
                }
            }
        };
        discoveryThread.start();
    }

    public void stopDiscoveryProcess() {
        this.discovering = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    private void performNodeDiscovery(List<IDiscoveryListener> listeners, String id) throws XBeeException {
        try {
            this.discoverDevicesAPI(listeners, id);
            this.notifyDiscoveryFinished(listeners, null);
        }
        finally {
            this.running = false;
            this.discovering = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverDevicesAPI(final List<IDiscoveryListener> listeners, final String id) throws XBeeException {
        if (this.deviceList == null) {
            this.deviceList = new ArrayList<RemoteXBeeDevice>();
        }
        this.deviceList.clear();
        IPacketReceiveListener packetReceiveListener = new IPacketReceiveListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void packetReceived(XBeePacket receivedPacket) {
                if (!NodeDiscovery.this.discovering) {
                    return;
                }
                RemoteXBeeDevice rdevice = null;
                byte[] commandValue = NodeDiscovery.this.getRemoteDeviceData((XBeeAPIPacket)receivedPacket);
                rdevice = NodeDiscovery.this.parseDiscoveryAPIData(commandValue, NodeDiscovery.this.xbeeDevice);
                if (id != null) {
                    if (rdevice != null && id.equals(rdevice.getNodeID())) {
                        List list = NodeDiscovery.this.deviceList;
                        synchronized (list) {
                            NodeDiscovery.this.deviceList.add(rdevice);
                        }
                        if (NodeDiscovery.this.xbeeDevice.getXBeeProtocol() != XBeeProtocol.RAW_802_15_4) {
                            NodeDiscovery.this.discovering = false;
                        }
                    }
                } else if (rdevice != null) {
                    NodeDiscovery.this.notifyDeviceDiscovered(listeners, rdevice);
                }
            }
        };
        this.logger.debug("{}Start listening.", (Object)this.xbeeDevice.toString());
        this.xbeeDevice.addPacketListener(packetReceiveListener);
        try {
            long deadLine = System.currentTimeMillis();
            boolean is802Compatible = this.is802Compatible();
            if (!is802Compatible) {
                deadLine += this.calculateTimeout(listeners);
            }
            this.sendNodeDiscoverCommand(id);
            if (!is802Compatible) {
                while (this.discovering) {
                    if (System.currentTimeMillis() < deadLine) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    this.discovering = false;
                }
            } else {
                while (this.discovering) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        finally {
            this.xbeeDevice.removePacketListener(packetReceiveListener);
            this.logger.debug("{}Stop listening.", (Object)this.xbeeDevice.toString());
        }
    }

    private long calculateTimeout(List<IDiscoveryListener> listeners) {
        long timeout = -1L;
        try {
            timeout = ByteUtils.byteArrayToLong(this.xbeeDevice.getParameter("N?"));
        }
        catch (XBeeException e) {
            this.logger.debug("{}Could not read the N? value.", (Object)this.xbeeDevice.toString());
        }
        if (timeout == -1L) {
            try {
                timeout = ByteUtils.byteArrayToLong(this.xbeeDevice.getParameter("NT")) * 100L;
            }
            catch (XBeeException e) {
                timeout = 20000L;
                String error = "Could not read the discovery timeout from the device (NT). The default timeout (20000 ms.) will be used.";
                this.notifyDiscoveryError(listeners, error);
            }
            if (this.xbeeDevice.getXBeeProtocol() == XBeeProtocol.DIGI_MESH) {
                timeout += 3000L;
            } else if (this.xbeeDevice.getXBeeProtocol() == XBeeProtocol.DIGI_POINT) {
                timeout += 8000L;
            }
        }
        if (this.xbeeDevice.getXBeeProtocol() == XBeeProtocol.DIGI_MESH) {
            try {
                boolean isSleepSupport;
                boolean bl = isSleepSupport = ByteUtils.byteArrayToInt(this.xbeeDevice.getParameter("SM")) == 7;
                if (isSleepSupport) {
                    timeout = (long)((double)timeout + ((double)timeout + (double)timeout * 0.1));
                }
            }
            catch (XBeeException e) {
                this.logger.debug("{}Could not determine if the module is 'Sleep Support'.", (Object)this.xbeeDevice.toString());
            }
        }
        return timeout;
    }

    private byte[] getRemoteDeviceData(XBeeAPIPacket packet) {
        byte[] data = null;
        this.logger.trace("{}Received packet: {}.", (Object)this.xbeeDevice.toString(), (Object)packet);
        APIFrameType frameType = packet.getFrameType();
        switch (frameType) {
            case AT_COMMAND_RESPONSE: {
                ATCommandResponsePacket atResponse = (ATCommandResponsePacket)packet;
                if (atResponse.getFrameID() != this.frameID) {
                    return null;
                }
                if (!atResponse.getCommand().equals(ND_COMMAND)) {
                    return null;
                }
                if (atResponse.getCommandValue() == null || atResponse.getCommandValue().length == 0) {
                    this.discovering = atResponse.getStatus() != ATCommandStatus.OK;
                    return null;
                }
                this.logger.debug("{}Received self response: {}.", (Object)this.xbeeDevice.toString(), (Object)packet);
                data = atResponse.getCommandValue();
                break;
            }
        }
        return data;
    }

    private RemoteXBeeDevice parseDiscoveryAPIData(byte[] data, XBeeDevice localDevice) {
        if (data == null) {
            return null;
        }
        RemoteXBeeDevice device = null;
        XBee16BitAddress addr16 = null;
        XBee64BitAddress addr64 = null;
        String id = null;
        int signalStrength = 0;
        byte[] profileID = null;
        byte[] manufacturerID = null;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        addr16 = new XBee16BitAddress(ByteUtils.readBytes(2, inputStream));
        addr64 = new XBee64BitAddress(ByteUtils.readBytes(8, inputStream));
        switch (localDevice.getXBeeProtocol()) {
            case ZIGBEE: 
            case DIGI_MESH: 
            case ZNET: 
            case DIGI_POINT: 
            case XLR: 
            case XLR_DM: 
            case SX: {
                id = ByteUtils.readString(inputStream);
                XBee16BitAddress parentAddress = new XBee16BitAddress(ByteUtils.readBytes(2, inputStream));
                ByteUtils.readBytes(1, inputStream);
                profileID = ByteUtils.readBytes(2, inputStream);
                manufacturerID = ByteUtils.readBytes(2, inputStream);
                this.logger.debug("{}Discovered {} device: 16-bit[{}], 64-bit[{}], id[{}], parent[{}], profile[{}], manufacturer[{}].", new Object[]{this.xbeeDevice.toString(), localDevice.getXBeeProtocol().getDescription(), addr16, addr64, id, parentAddress, HexUtils.byteArrayToHexString(profileID), HexUtils.byteArrayToHexString(manufacturerID)});
                break;
            }
            case RAW_802_15_4: {
                signalStrength = inputStream.read();
                id = ByteUtils.readString(inputStream);
                this.logger.debug("{}Discovered {} device: 16-bit[{}], 64-bit[{}], id[{}], rssi[{}].", new Object[]{this.xbeeDevice.toString(), localDevice.getXBeeProtocol().getDescription(), addr16, addr64, id, signalStrength});
                break;
            }
            default: {
                this.logger.debug("{}Discovered {} device: 16-bit[{}], 64-bit[{}].", new Object[]{this.xbeeDevice.toString(), localDevice.getXBeeProtocol().getDescription(), addr16, addr64});
            }
        }
        switch (localDevice.getXBeeProtocol()) {
            case ZIGBEE: {
                device = new RemoteZigBeeDevice(localDevice, addr64, addr16, id);
                break;
            }
            case DIGI_MESH: {
                device = new RemoteDigiMeshDevice(localDevice, addr64, id);
                break;
            }
            case DIGI_POINT: {
                device = new RemoteDigiPointDevice(localDevice, addr64, id);
                break;
            }
            case RAW_802_15_4: {
                device = new RemoteRaw802Device(localDevice, addr64, addr16, id);
                break;
            }
            default: {
                device = new RemoteXBeeDevice(localDevice, addr64, addr16, id);
            }
        }
        return device;
    }

    private void sendNodeDiscoverCommand(String id) throws XBeeException {
        if (id == null) {
            this.xbeeDevice.sendPacketAsync(new ATCommandPacket(this.frameID, ND_COMMAND, ""));
        } else {
            this.xbeeDevice.sendPacketAsync(new ATCommandPacket(this.frameID, ND_COMMAND, id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDeviceDiscovered(List<IDiscoveryListener> listeners, RemoteXBeeDevice device) {
        if (listeners == null) {
            List<RemoteXBeeDevice> list = this.deviceList;
            synchronized (list) {
                this.deviceList.add(device);
            }
            return;
        }
        XBeeNetwork network = this.xbeeDevice.getNetwork();
        RemoteXBeeDevice addedDev = network.addRemoteDevice(device);
        if (addedDev != null) {
            for (IDiscoveryListener listener : listeners) {
                listener.deviceDiscovered(addedDev);
            }
        } else {
            String error = "Error adding device '" + device + "' to the network.";
            this.notifyDiscoveryError(listeners, error);
        }
    }

    private void notifyDiscoveryError(List<IDiscoveryListener> listeners, String error) {
        this.logger.error("{}Error discovering devices: {}", (Object)this.xbeeDevice.toString(), (Object)error);
        if (listeners == null) {
            return;
        }
        for (IDiscoveryListener listener : listeners) {
            listener.discoveryError(error);
        }
    }

    private void notifyDiscoveryFinished(List<IDiscoveryListener> listeners, String error) {
        if (error != null && error.length() > 0) {
            this.logger.error("{}Finished discovery: {}", (Object)this.xbeeDevice.toString(), (Object)error);
        } else {
            this.logger.debug("{}Finished discovery.", (Object)this.xbeeDevice.toString());
        }
        if (listeners == null) {
            return;
        }
        for (IDiscoveryListener listener : listeners) {
            listener.discoveryFinished(error);
        }
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.xbeeDevice.toString() + "] @" + Integer.toHexString(this.hashCode());
    }

    private boolean is802Compatible() {
        if (this.xbeeDevice.getXBeeProtocol() != XBeeProtocol.RAW_802_15_4) {
            return false;
        }
        byte[] param = null;
        try {
            param = this.xbeeDevice.getParameter("C8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return param == null || (param[0] & 2) == 2;
    }
}

