/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api;

import android.content.Context;
import com.digi.xbee.api.CellularDevice;
import com.digi.xbee.api.XBee;
import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.connection.android.AndroidUSBPermissionListener;
import com.digi.xbee.api.connection.serial.SerialPortParameters;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.listeners.ISMSReceiveListener;
import com.digi.xbee.api.models.IPProtocol;
import java.net.Inet4Address;

public class LPWANDevice
extends CellularDevice {
    private static final String OPERATION_EXCEPTION = "Operation not supported in this module.";
    private static final String ONLY_UDP_TRANSMISSIONS = "This protocol only supports UDP transmissions.";

    protected LPWANDevice(String port, int baudRate) {
        this(XBee.createConnectiontionInterface(port, baudRate));
    }

    protected LPWANDevice(String port, int baudRate, int dataBits, int stopBits, int parity, int flowControl) {
        this(port, new SerialPortParameters(baudRate, dataBits, stopBits, parity, flowControl));
    }

    protected LPWANDevice(String port, SerialPortParameters serialPortParameters) {
        this(XBee.createConnectiontionInterface(port, serialPortParameters));
    }

    protected LPWANDevice(Context context, int baudRate) {
        super(XBee.createConnectiontionInterface(context, baudRate));
    }

    protected LPWANDevice(Context context, int baudRate, AndroidUSBPermissionListener permissionListener) {
        super(XBee.createConnectiontionInterface(context, baudRate, permissionListener));
    }

    protected LPWANDevice(Context context, String port, int baudRate) {
        super(XBee.createConnectiontionInterface(context, port, baudRate));
    }

    protected LPWANDevice(Context context, String port, SerialPortParameters parameters) {
        super(XBee.createConnectiontionInterface(context, port, parameters));
    }

    protected LPWANDevice(IConnectionInterface connectionInterface) {
        super(connectionInterface);
    }

    @Override
    public void addSMSListener(ISMSReceiveListener listener) {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void removeSMSListener(ISMSReceiveListener listener) {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void sendSMS(String phoneNumber, String data) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void sendSMSAsync(String phoneNumber, String data) throws TimeoutException, XBeeException {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    @Override
    public void sendIPData(Inet4Address ipAddress, int destPort, IPProtocol protocol, byte[] data) throws TimeoutException, XBeeException {
        if (protocol != IPProtocol.UDP) {
            throw new IllegalArgumentException(ONLY_UDP_TRANSMISSIONS);
        }
        super.sendIPData(ipAddress, destPort, protocol, data);
    }

    @Override
    public void sendIPData(Inet4Address ipAddress, int destPort, IPProtocol protocol, boolean closeSocket, byte[] data) throws TimeoutException, XBeeException {
        this.sendIPData(ipAddress, destPort, protocol, data);
    }

    @Override
    public void sendIPDataAsync(Inet4Address ipAddress, int destPort, IPProtocol protocol, byte[] data) throws TimeoutException, XBeeException {
        if (protocol != IPProtocol.UDP) {
            throw new IllegalArgumentException(ONLY_UDP_TRANSMISSIONS);
        }
        super.sendIPDataAsync(ipAddress, destPort, protocol, data);
    }

    @Override
    public void sendIPDataAsync(Inet4Address ipAddress, int destPort, IPProtocol protocol, boolean closeSocket, byte[] data) throws XBeeException {
        this.sendIPDataAsync(ipAddress, destPort, protocol, data);
    }
}

